/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.functional.ThrowingConsumer;
import org.apache.causeway.commons.functional.ThrowingFunction;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public final class FileUtils {
    public static <T> Try<T> tryReadAndApply(@Nullable File file, @NonNull ThrowingFunction<InputStream, T> inputStreamMapper) {
        if (inputStreamMapper == null) {
            throw new NullPointerException("inputStreamMapper is marked non-null but is null");
        }
        return Try.call(() -> {
            try (FileInputStream inputStream = new FileInputStream(FileUtils.existingFileElseFail(file));){
                Object r = inputStreamMapper.apply(inputStream);
                return r;
            }
        });
    }

    public static Try<Void> tryReadAndAccept(@Nullable File file, @NonNull ThrowingConsumer<InputStream> inputStreamConsumer) {
        if (inputStreamConsumer == null) {
            throw new NullPointerException("inputStreamConsumer is marked non-null but is null");
        }
        return Try.run(() -> {
            try (FileInputStream inputStream = new FileInputStream(FileUtils.existingFileElseFail(file));){
                inputStreamConsumer.accept(inputStream);
            }
        });
    }

    public static Set<File> searchFiles(File dir, Predicate<File> dirFilter, Predicate<File> fileFilter) {
        LinkedHashSet<File> fileList = new LinkedHashSet<File>();
        FileUtils.searchFiles(dir, dirFilter, fileFilter, fileList::add);
        return fileList;
    }

    public static void searchFiles(File dir, Predicate<File> dirFilter, Predicate<File> fileFilter, Consumer<File> onFileFound) {
        if (!dir.exists()) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toPath());){
            for (Path path : stream) {
                File file = path.toFile();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (!dirFilter.test(file)) continue;
                    FileUtils.searchFiles(file, dirFilter, fileFilter, onFileFound);
                    continue;
                }
                if (!fileFilter.test(file)) continue;
                onFileFound.accept(file);
            }
        }
    }

    public static Optional<String> canonicalPath(@Nullable File file) {
        if (file == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(file.getCanonicalPath());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String toRelativePath(@NonNull String commonPath, @NonNull String absolutePath) {
        if (commonPath == null) {
            throw new NullPointerException("commonPath is marked non-null but is null");
        }
        if (absolutePath == null) {
            throw new NullPointerException("absolutePath is marked non-null but is null");
        }
        if (absolutePath.startsWith(commonPath)) {
            return absolutePath.substring(commonPath.length());
        }
        return absolutePath;
    }

    public static void deleteFile(@Nullable File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return;
        }
        Files.delete(file.toPath());
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                FileUtils.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static File tempDir(String name) {
        File tempDir = Files.createTempDirectory(name, new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static String realtiveFileName(File root, File file) {
        return file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
    }

    public static Function<File, String> realtiveFileName(File root) {
        return file -> FileUtils.realtiveFileName(root, file);
    }

    public static File makeDir(@Nullable File directory) {
        if (directory == null) {
            return directory;
        }
        if (directory.exists()) {
            if (directory.isDirectory()) {
                return directory;
            }
            throw _Exceptions.illegalArgument("cannot create directory over pre-existing file of same name %s", directory.getAbsolutePath());
        }
        if (!directory.mkdirs()) {
            throw _Exceptions.unrecoverable("failed to create directory %s", directory.getAbsolutePath());
        }
        return directory;
    }

    public static Optional<File> existingFile(@Nullable File file) {
        return file != null && file.isFile() ? Optional.of(file) : Optional.empty();
    }

    public static File existingFileElseFail(@Nullable File file) {
        if (file == null) {
            throw new NoSuchFileException("<null>");
        }
        if (!file.exists()) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        return file;
    }

    public static Optional<File> existingDirectory(@Nullable File file) {
        return file != null && file.isDirectory() ? Optional.of(file) : Optional.empty();
    }

    public static File existingDirectoryElseFail(@Nullable File file) {
        if (file == null) {
            throw new NoSuchFileException("<null>");
        }
        if (!file.exists()) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new NotDirectoryException(file.getAbsolutePath());
        }
        return file;
    }

    public static void copy(@NonNull File from, @NonNull File to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyLines(@NonNull File from, @NonNull File to, @NonNull Charset charset, @NonNull UnaryOperator<String> lineProcessor, OpenOption ... openOptions) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (lineProcessor == null) {
            throw new NullPointerException("lineProcessor is marked non-null but is null");
        }
        if (openOptions == null) {
            throw new NullPointerException("openOptions is marked non-null but is null");
        }
        try (BufferedReader reader = Files.newBufferedReader(from.toPath(), charset);
             BufferedWriter writer = Files.newBufferedWriter(to.toPath(), charset, openOptions);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write((String)lineProcessor.apply(line));
                writer.write("\n");
            }
        }
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

