/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.collections;

import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.causeway.commons.collections.Cardinality;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public interface ImmutableCollection<E>
extends Iterable<E> {
    public int size();

    public boolean isEmpty();

    public Cardinality getCardinality();

    public boolean contains(@Nullable E var1);

    public Optional<E> getSingleton();

    default public E getSingletonOrFail() {
        return this.getSingleton().orElseThrow(_Exceptions::noSuchElement);
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }
}

