/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.binding;

import java.lang.ref.WeakReference;
import lombok.NonNull;
import org.apache.causeway.commons.binding.Bindable;
import org.apache.causeway.commons.binding.ChangeListener;
import org.apache.causeway.commons.binding.Observable;
import org.apache.causeway.commons.internal.binding.InternalUtil;
import org.apache.causeway.commons.internal.exceptions._Exceptions;

abstract class InternalBidirectionalBinding<T>
implements ChangeListener<T>,
InternalUtil.WeakListener {
    private final int cachedHash;

    public static <T> InternalBidirectionalBinding<T> bind(Bindable<T> left, Bindable<T> right) {
        InternalBidirectionalBinding.checkParameters(left, right);
        GenericBidirectionalBinding<T> binding = new GenericBidirectionalBinding<T>(left, right);
        left.setValue(right.getValue());
        left.addListener(binding);
        right.addListener(binding);
        return binding;
    }

    public static <T> void unbind(Bindable<T> left, Bindable<T> right) {
        InternalBidirectionalBinding.checkParameters(left, right);
        UntypedBidirectionalBinding binding = new UntypedBidirectionalBinding(left, right);
        left.removeListener(binding);
        right.removeListener(binding);
    }

    public static void unbind(Object left, Object right) {
        InternalBidirectionalBinding.checkParameters(left, right);
        UntypedBidirectionalBinding binding = new UntypedBidirectionalBinding(left, right);
        if (left instanceof Observable) {
            ((Observable)left).removeListener(binding);
        }
        if (right instanceof Observable) {
            ((Observable)right).removeListener(binding);
        }
    }

    protected abstract Object getLeft();

    protected abstract Object getRight();

    public int hashCode() {
        return this.cachedHash;
    }

    @Override
    public boolean isNoLongerReferenced() {
        return this.getLeft() == null || this.getRight() == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object left = this.getLeft();
        Object right = this.getRight();
        if (left == null || right == null) {
            return false;
        }
        if (obj instanceof InternalBidirectionalBinding) {
            InternalBidirectionalBinding otherBinding = (InternalBidirectionalBinding)obj;
            Object otherLeft = otherBinding.getLeft();
            Object otherRight = otherBinding.getRight();
            if (otherLeft == null || otherRight == null) {
                return false;
            }
            if (left == otherLeft && right == otherRight) {
                return true;
            }
            if (left == otherRight && right == otherLeft) {
                return true;
            }
        }
        return false;
    }

    private static void checkParameters(@NonNull Object left, @NonNull Object right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        if (left == right) {
            throw _Exceptions.illegalArgument("Cannot bind to self", new Object[0]);
        }
    }

    private InternalBidirectionalBinding(Object left, Object right) {
        this.cachedHash = left.hashCode() * right.hashCode();
    }

    private static class GenericBidirectionalBinding<T>
    extends InternalBidirectionalBinding<T> {
        private final WeakReference<Bindable<T>> leftRef;
        private final WeakReference<Bindable<T>> rightRef;
        private boolean updating = false;

        private GenericBidirectionalBinding(Bindable<T> left, Bindable<T> right) {
            super(left, right);
            this.leftRef = new WeakReference<Bindable<Bindable<T>>>(left);
            this.rightRef = new WeakReference<Bindable<Bindable<T>>>(right);
        }

        @Override
        protected Bindable<T> getLeft() {
            return (Bindable)this.leftRef.get();
        }

        @Override
        protected Bindable<T> getRight() {
            return (Bindable)this.rightRef.get();
        }

        @Override
        public void changed(Observable<? extends T> observable, T oldValue, T newValue) {
            if (this.updating) {
                return;
            }
            Object left = this.getLeft();
            Object right = this.getRight();
            if (left == null || right == null) {
                if (left != null) {
                    left.removeListener(this);
                }
                if (right != null) {
                    right.removeListener(this);
                }
                return;
            }
            try {
                this.updating = true;
                if (left == observable) {
                    right.setValue(newValue);
                } else {
                    left.setValue(newValue);
                }
            }
            catch (RuntimeException e) {
                try {
                    if (left == observable) {
                        left.setValue(oldValue);
                    } else {
                        right.setValue(oldValue);
                    }
                }
                catch (Exception e2) {
                    e2.addSuppressed(e);
                    GenericBidirectionalBinding.unbind(left, right);
                    throw _Exceptions.unrecoverable(e2, "Bidirectional binding failed with an attempt to restore the Observable to the previous value. Removing the bidirectional binding from bindables %s and %s", "" + (Bindable)left, "" + (Bindable)right);
                }
                throw _Exceptions.unrecoverable(e, "Bidirectional binding failed, setting to the previous value");
            }
            finally {
                this.updating = false;
            }
        }
    }

    private static class UntypedBidirectionalBinding
    extends InternalBidirectionalBinding<Object> {
        private final Object left;
        private final Object right;

        public UntypedBidirectionalBinding(Object left, Object right) {
            super(left, right);
            this.left = left;
            this.right = right;
        }

        @Override
        public void changed(Observable<? extends Object> sourceProperty, Object oldValue, Object newValue) {
            throw _Exceptions.unexpectedCodeReach();
        }

        @Override
        public Object getLeft() {
            return this.left;
        }

        @Override
        public Object getRight() {
            return this.right;
        }
    }
}

