/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.Can_Singleton;
import org.apache.causeway.commons.collections.Cardinality;
import org.apache.causeway.commons.collections._CanFactory;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Objects;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

final class Can_Multiple<T>
implements Can<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> elements;

    @Override
    public Optional<T> getFirst() {
        return Optional.of(this.elements.get(0));
    }

    @Override
    public Optional<T> getLast() {
        return Optional.of(this.elements.get(this.size() - 1));
    }

    @Override
    public Cardinality getCardinality() {
        return Cardinality.MULTIPLE;
    }

    @Override
    public Stream<T> stream() {
        return this.elements.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.elements.parallelStream();
    }

    @Override
    public Optional<T> getSingleton() {
        return Optional.empty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(@Nullable T element) {
        if (element == null) {
            return false;
        }
        return this.elements.contains(element);
    }

    @Override
    public Optional<T> get(int elementIndex) {
        int size = this.size();
        if (size == 0) {
            return Optional.empty();
        }
        boolean minIndex = false;
        int maxIndex = size - 1;
        if (elementIndex < 0 || elementIndex > maxIndex) {
            return Optional.empty();
        }
        return Optional.of(this.elements.get(elementIndex));
    }

    @Override
    public Can<T> sorted(@NonNull Comparator<? super T> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        ArrayList<T> newElements = _Lists.newArrayList(this.elements);
        newElements.sort(c);
        return Can_Multiple.of(newElements);
    }

    @Override
    public Can<T> distinct() {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(this.elements);
        return Can.ofCollection(set);
    }

    @Override
    public Can<T> distinct(@NonNull BiPredicate<T, T> equality) {
        if (equality == null) {
            throw new NullPointerException("equality is marked non-null but is null");
        }
        int initialSize = Math.min(1024, this.elements.size());
        ArrayList uniqueElements = _Lists.newArrayList(initialSize);
        this.elements.forEach(element -> {
            if (!uniqueElements.stream().anyMatch(x -> equality.test(x, element))) {
                uniqueElements.add(element);
            }
        });
        return _CanFactory.ofNonNullElements(uniqueElements);
    }

    @Override
    public Iterator<T> iterator(int skip, int limit) {
        return Collections.unmodifiableList(this.elements).stream().skip(skip).limit(limit).iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.elements).iterator();
    }

    @Override
    public Iterator<T> reverseIterator() {
        return new Iterator<T>(){
            private int remainingCount;
            {
                this.remainingCount = Can_Multiple.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.remainingCount > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw _Exceptions.noSuchElement();
                }
                return Can_Multiple.this.elements.get(--this.remainingCount);
            }
        };
    }

    @Override
    public Can<T> reverse() {
        ArrayList<T> reverse = new ArrayList<T>(this.elements.size());
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            reverse.add(this.elements.get(i));
        }
        return Can_Multiple.of(reverse);
    }

    @Override
    public Can<T> reduce(@NonNull BinaryOperator<T> accumulator) {
        if (accumulator == null) {
            throw new NullPointerException("accumulator is marked non-null but is null");
        }
        return this.stream().reduce(accumulator).map((? super T singleton) -> Can_Singleton.of(singleton)).orElseGet(Can::empty);
    }

    @Override
    public void forEach(@NonNull Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.elements.forEach(action);
    }

    @Override
    public Can<T> filter(@Nullable Predicate<? super T> predicate) {
        if (predicate == null) {
            return this;
        }
        ArrayList filteredElements = this.stream().filter(predicate).collect(Collectors.toCollection(ArrayList::new));
        if (filteredElements.size() == this.size()) {
            return this;
        }
        return Can.ofCollection(filteredElements);
    }

    @Override
    public <R> void zip(@NonNull Iterable<R> zippedIn, @NonNull BiConsumer<? super T, ? super R> action) {
        if (zippedIn == null) {
            throw new NullPointerException("zippedIn is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        Iterator zippedInIterator = zippedIn.iterator();
        this.stream().forEach(t -> action.accept((Object)t, (Object)zippedInIterator.next()));
    }

    @Override
    public <R, Z> Can<R> zipMap(@NonNull Iterable<Z> zippedIn, @NonNull BiFunction<? super T, ? super Z, R> mapper) {
        if (zippedIn == null) {
            throw new NullPointerException("zippedIn is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        Iterator zippedInIterator = zippedIn.iterator();
        return this.map(t -> mapper.apply((Object)t, (Object)zippedInIterator.next()));
    }

    @Override
    public Can<T> add(@Nullable T element) {
        return element != null ? Can.ofStream(Stream.concat(this.elements.stream(), Stream.of(element))) : this;
    }

    @Override
    public Can<T> addAll(@Nullable Can<T> other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        ArrayList<T> newElements = new ArrayList<T>(this.size() + other.size());
        newElements.addAll(this.elements);
        other.forEach(newElements::add);
        return Can_Multiple.of(newElements);
    }

    @Override
    public Can<T> add(int index, @Nullable T element) {
        if (element == null) {
            return this;
        }
        ArrayList<T> newElements = new ArrayList<T>(this.elements);
        newElements.add(index, element);
        return Can.ofCollection(newElements);
    }

    @Override
    public Can<T> replace(int index, @Nullable T element) {
        if (element == null) {
            return this.remove((T)index);
        }
        ArrayList<T> newElements = new ArrayList<T>(this.elements);
        newElements.set(index, element);
        return Can.ofCollection(newElements);
    }

    @Override
    public Can<T> remove(int index) {
        ArrayList<T> newElements = new ArrayList<T>(this.elements);
        newElements.remove(index);
        return Can.ofCollection(newElements);
    }

    @Override
    public Can<T> remove(@Nullable T element) {
        if (element == null) {
            return this;
        }
        ArrayList<T> newElements = new ArrayList<T>(this.elements);
        newElements.remove(element);
        return Can.ofCollection(newElements);
    }

    @Override
    public Can<T> pickByIndex(int ... indices) {
        if (indices == null || indices.length == 0) {
            return Can.empty();
        }
        ArrayList<T> newElements = new ArrayList<T>(indices.length);
        int maxIndex = this.size() - 1;
        for (int index : indices) {
            if (index < 0 || index > maxIndex) continue;
            newElements.add(this.elements.get(index));
        }
        return Can.ofCollection(newElements);
    }

    @Override
    public Can<T> pickByIndex(@Nullable IntStream intStream) {
        if (intStream == null) {
            return Can.empty();
        }
        ArrayList newElements = new ArrayList();
        int maxIndex = this.size() - 1;
        intStream.filter((int index) -> index >= 0 && index <= maxIndex).forEach((int index) -> newElements.add(this.elements.get(index)));
        return _CanFactory.ofNonNullElements(newElements);
    }

    @Override
    public Can<T> subCan(int startInclusive) {
        return this.pickByIndex(IntStream.range(startInclusive, this.size()));
    }

    @Override
    public Can<T> subCan(int startInclusive, int endExclusive) {
        int upperBoundExclusive;
        int n = upperBoundExclusive = endExclusive < 0 ? this.size() + endExclusive : endExclusive;
        if (startInclusive >= upperBoundExclusive) {
            return Can.empty();
        }
        return this.pickByIndex(IntStream.range(startInclusive, upperBoundExclusive));
    }

    @Override
    public Can<Can<T>> partitionInnerBound(int maxInnerSize) {
        if (maxInnerSize < 1) {
            throw _Exceptions.illegalArgument("maxInnerSize %d must be greater or equal to 1", maxInnerSize);
        }
        int n = this.size();
        int subCanCount = (n - 1) / maxInnerSize + 1;
        ArrayList<Can<T>> newElements = new ArrayList<Can<T>>(subCanCount);
        for (int i = 0; i < n; i += maxInnerSize) {
            newElements.add(this.subCan(i, i + maxInnerSize));
        }
        return _CanFactory.ofNonNullElements(newElements);
    }

    @Override
    public Can<Can<T>> partitionOuterBound(int outerSizeYield) {
        if (outerSizeYield < 1) {
            throw _Exceptions.illegalArgument("outerSizeYield %d must be greater or equal to 1", outerSizeYield);
        }
        int n = this.size();
        int maxInnerSize = (n - 1) / outerSizeYield + 1;
        return this.partitionInnerBound(maxInnerSize);
    }

    @Override
    public int indexOf(@Nullable T element) {
        return this.elements.indexOf(element);
    }

    public String toString() {
        String literal = this.stream().map((? super T s) -> "" + s).collect(Collectors.joining(", "));
        return "Can[" + literal + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Can) {
            return ((Can)obj).isEqualTo(this);
        }
        return false;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public int compareTo(@Nullable Can<T> other) {
        int firstElementComparison;
        if (other == null || other.isEmpty()) {
            return 1;
        }
        if (other.isCardinalityOne() && (firstElementComparison = _Objects.compareNonNull(this.elements.get(0), other.getSingletonOrFail())) != 0) {
            return firstElementComparison;
        }
        if (this.size() >= other.size()) {
            Iterator otherIterator = other.iterator();
            for (T left : this) {
                if (!otherIterator.hasNext()) {
                    return 1;
                }
                Object right = otherIterator.next();
                int c = _Objects.compareNonNull(left, right);
                if (c == 0) continue;
                return c;
            }
        } else {
            Iterator<T> thisIterator = this.iterator();
            for (Object right : other) {
                if (!thisIterator.hasNext()) {
                    return -1;
                }
                T left = thisIterator.next();
                int c = _Objects.compareNonNull(left, right);
                if (c == 0) continue;
                return c;
            }
        }
        return 0;
    }

    @Override
    public List<T> toList() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public List<T> toArrayList() {
        return _Lists.newArrayList(this.elements);
    }

    @Override
    public Set<T> toSet() {
        HashSet set = _Sets.newHashSet();
        set.addAll(this.elements);
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set<T> toSet(@NonNull Consumer<T> onDuplicated) {
        if (onDuplicated == null) {
            throw new NullPointerException("onDuplicated is marked non-null but is null");
        }
        HashSet set = _Sets.newHashSet();
        this.elements.forEach(s -> {
            if (!set.add(s)) {
                onDuplicated.accept(s);
            }
        });
        return Collections.unmodifiableSet(set);
    }

    @Override
    public <C extends Collection<T>> C toCollection(@NonNull Supplier<C> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        Collection collection = (Collection)collectionFactory.get();
        collection.addAll(this.elements);
        return (C)collection;
    }

    @Override
    public T[] toArray(@NonNull Class<T> elementType) {
        if (elementType == null) {
            throw new NullPointerException("elementType is marked non-null but is null");
        }
        Object[] array = (Object[])_Casts.uncheckedCast(Array.newInstance(elementType, this.size()));
        return this.elements.toArray(array);
    }

    @Generated
    private Can_Multiple(List<T> elements) {
        this.elements = elements;
    }

    @Generated
    public static <T> Can_Multiple<T> of(List<T> elements) {
        return new Can_Multiple<T>(elements);
    }
}

