/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.context;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Lists;

public final class _Context {
    private static final Map<Class<?>, Object> singletonMap = new ConcurrentHashMap();
    private static final Object $LOCK = new Object[0];
    private static final Supplier<ClassLoader> FALLBACK_CLASSLOADER = Thread.currentThread()::getContextClassLoader;

    private _Context() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void putSingleton(@NonNull Class<? super T> type, @NonNull T singleton) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (singleton == null) {
            throw new NullPointerException("singleton is marked non-null but is null");
        }
        Object object = $LOCK;
        synchronized (object) {
            if (singletonMap.containsKey(type)) {
                throw new IllegalStateException("there is already a singleton of type '" + String.valueOf(type) + "' on this context.");
            }
            singletonMap.put(type, singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean put(@NonNull Class<? super T> type, @NonNull T singleton, boolean override) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (singleton == null) {
            throw new NullPointerException("singleton is marked non-null but is null");
        }
        Object object = $LOCK;
        synchronized (object) {
            if (singletonMap.containsKey(type) && !override) {
                return false;
            }
            singletonMap.put(type, singleton);
            return true;
        }
    }

    public static <T> Optional<T> lookup(Class<? super T> type) {
        return Optional.ofNullable(_Context.getIfAny(type));
    }

    public static <T> T getIfAny(Class<? super T> type) {
        return _Casts.uncheckedCast(singletonMap.get(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeIfAbsent(@NonNull Class<? super T> type, @NonNull Function<Class<? super T>, T> factory) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        Object existingIfAny = _Casts.uncheckedCast(singletonMap.get(type));
        if (existingIfAny != null) {
            return existingIfAny;
        }
        T t = factory.apply(type);
        if (t == null) {
            return null;
        }
        Object object = $LOCK;
        synchronized (object) {
            Object existingIfAny2 = _Casts.uncheckedCast(singletonMap.get(type));
            if (existingIfAny2 != null) {
                return existingIfAny2;
            }
            singletonMap.put(type, t);
            return t;
        }
    }

    public static <T> T computeIfAbsent(@NonNull Class<? super T> type, @NonNull Supplier<T> factory) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return (T)_Context.computeIfAbsent(type, (Class<? super T> __) -> factory.get());
    }

    public static <T> T getOrElse(Class<? super T> type, @NonNull Supplier<T> fallback) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        return Optional.ofNullable(_Casts.uncheckedCast(_Context.getIfAny(type))).orElseGet(fallback);
    }

    public static <T, E extends Exception> T getElseThrow(@NonNull Class<? super T> type, @NonNull Supplier<E> onNotFound) throws E {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (onNotFound == null) {
            throw new NullPointerException("onNotFound is marked non-null but is null");
        }
        return Optional.ofNullable(_Casts.uncheckedCast(_Context.getIfAny(type))).orElseThrow(onNotFound);
    }

    public static <T> T getElseFail(Class<? super T> type) {
        return Optional.ofNullable(_Casts.uncheckedCast(_Context.getIfAny(type))).orElseThrow(() -> new NoSuchElementException(String.format("Could not resolve an instance of type '%s'", type.getName())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Class<?> type) {
        Object object = $LOCK;
        synchronized (object) {
            singletonMap.remove(type);
        }
        _Context.tryClose(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = $LOCK;
        synchronized (object) {
            _Context.closeAnyClosables(_Lists.newArrayList(singletonMap.values()));
            singletonMap.clear();
        }
    }

    private static void closeAnyClosables(List<Object> objects) {
        _NullSafe.stream(objects).forEach(_Context::tryClose);
    }

    public static ClassLoader getDefaultClassLoader() {
        return _Context.getOrElse(ClassLoader.class, FALLBACK_CLASSLOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultClassLoader(@NonNull ClassLoader classLoader, boolean override) {
        boolean alreadyRegistered;
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        boolean bl = alreadyRegistered = _Context.getIfAny(ClassLoader.class) != null;
        if (!alreadyRegistered || override) {
            Object object = $LOCK;
            synchronized (object) {
                singletonMap.put(ClassLoader.class, classLoader);
            }
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return _Context.getDefaultClassLoader().loadClass(className);
    }

    public static Class<?> loadClassAndInitialize(String className) throws ClassNotFoundException {
        return Class.forName(className, true, _Context.getDefaultClassLoader());
    }

    public static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    private static void tryClose(Object singleton) {
        if (singleton == null) {
            return;
        }
        if (singleton instanceof AutoCloseable) {
            try {
                ((AutoCloseable)singleton).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

