/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;

public final class _BootstrapBadge {
    private final String caption;
    private final String faIcon;
    private final String href;
    private final String tooltip;
    private final String nestedCaption;
    private final List<String> cssClasses;

    public String toHtml() {
        return _Strings.isNotEmpty(this.getHref()) ? this.link() : this.noLink();
    }

    public String noLink() {
        StringBuilder sb = new StringBuilder();
        sb.append("<span ").append("class=\"").append(this.classesLiteral("badge", "bg-light")).append("\"");
        if (_Strings.isNotEmpty(this.getTooltip())) {
            sb.append(" data-bs-container=\"body\" data-bs-toggle=\"tooltip\" title=\"" + this.getTooltip() + "\"");
        }
        sb.append(">");
        if (_Strings.isNotEmpty(this.getFaIcon())) {
            sb.append("<i class=\"").append(this.getFaIcon()).append("\"></i>");
        }
        sb.append(this.getCaption()).append("</span>");
        return sb.toString();
    }

    public String link() {
        StringBuilder sb = new StringBuilder();
        sb.append("<a ").append("class=\"").append(this.classesLiteral("btn", "btn-sm", "bg-light")).append("\"").append(" href=\"").append(this.getHref()).append("\"").append(" target=\"").append("_blank").append("\"");
        sb.append(">");
        sb.append(this.getCaption());
        if (_Strings.isNotEmpty(this.getNestedCaption())) {
            sb.append(String.format(" <span class=\"badge text-sm text-bg-secondary\">%s</span>", this.getNestedCaption()));
        }
        sb.append("</a>");
        return sb.toString();
    }

    private String classesLiteral(String ... primaryClasses) {
        return Stream.concat(_NullSafe.stream(primaryClasses), _NullSafe.stream(this.cssClasses)).collect(Collectors.joining(" "));
    }

    @Generated
    _BootstrapBadge(String caption, String faIcon, String href, String tooltip, String nestedCaption, List<String> cssClasses) {
        this.caption = caption;
        this.faIcon = faIcon;
        this.href = href;
        this.tooltip = tooltip;
        this.nestedCaption = nestedCaption;
        this.cssClasses = cssClasses;
    }

    @Generated
    public static _BootstrapBadgeBuilder builder() {
        return new _BootstrapBadgeBuilder();
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getFaIcon() {
        return this.faIcon;
    }

    @Generated
    public String getHref() {
        return this.href;
    }

    @Generated
    public String getTooltip() {
        return this.tooltip;
    }

    @Generated
    public String getNestedCaption() {
        return this.nestedCaption;
    }

    @Generated
    public List<String> getCssClasses() {
        return this.cssClasses;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof _BootstrapBadge)) {
            return false;
        }
        _BootstrapBadge other = (_BootstrapBadge)o;
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$faIcon = this.getFaIcon();
        String other$faIcon = other.getFaIcon();
        if (this$faIcon == null ? other$faIcon != null : !this$faIcon.equals(other$faIcon)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$tooltip = this.getTooltip();
        String other$tooltip = other.getTooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        String this$nestedCaption = this.getNestedCaption();
        String other$nestedCaption = other.getNestedCaption();
        if (this$nestedCaption == null ? other$nestedCaption != null : !this$nestedCaption.equals(other$nestedCaption)) {
            return false;
        }
        List<String> this$cssClasses = this.getCssClasses();
        List<String> other$cssClasses = other.getCssClasses();
        return !(this$cssClasses == null ? other$cssClasses != null : !((Object)this$cssClasses).equals(other$cssClasses));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $faIcon = this.getFaIcon();
        result = result * 59 + ($faIcon == null ? 43 : $faIcon.hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        String $nestedCaption = this.getNestedCaption();
        result = result * 59 + ($nestedCaption == null ? 43 : $nestedCaption.hashCode());
        List<String> $cssClasses = this.getCssClasses();
        result = result * 59 + ($cssClasses == null ? 43 : ((Object)$cssClasses).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "_BootstrapBadge(caption=" + this.getCaption() + ", faIcon=" + this.getFaIcon() + ", href=" + this.getHref() + ", tooltip=" + this.getTooltip() + ", nestedCaption=" + this.getNestedCaption() + ", cssClasses=" + String.valueOf(this.getCssClasses()) + ")";
    }

    @Generated
    public static class _BootstrapBadgeBuilder {
        @Generated
        private String caption;
        @Generated
        private String faIcon;
        @Generated
        private String href;
        @Generated
        private String tooltip;
        @Generated
        private String nestedCaption;
        @Generated
        private ArrayList<String> cssClasses;

        @Generated
        _BootstrapBadgeBuilder() {
        }

        @Generated
        public _BootstrapBadgeBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder faIcon(String faIcon) {
            this.faIcon = faIcon;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder href(String href) {
            this.href = href;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder tooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder nestedCaption(String nestedCaption) {
            this.nestedCaption = nestedCaption;
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder cssClass(String cssClass) {
            if (this.cssClasses == null) {
                this.cssClasses = new ArrayList();
            }
            this.cssClasses.add(cssClass);
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder cssClasses(Collection<? extends String> cssClasses) {
            if (cssClasses == null) {
                throw new NullPointerException("cssClasses cannot be null");
            }
            if (this.cssClasses == null) {
                this.cssClasses = new ArrayList();
            }
            this.cssClasses.addAll(cssClasses);
            return this;
        }

        @Generated
        public _BootstrapBadgeBuilder clearCssClasses() {
            if (this.cssClasses != null) {
                this.cssClasses.clear();
            }
            return this;
        }

        @Generated
        public _BootstrapBadge build() {
            return new _BootstrapBadge(this.caption, this.faIcon, this.href, this.tooltip, this.nestedCaption, switch (this.cssClasses == null ? 0 : this.cssClasses.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.cssClasses.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.cssClasses));
            });
        }

        @Generated
        public String toString() {
            return "_BootstrapBadge._BootstrapBadgeBuilder(caption=" + this.caption + ", faIcon=" + this.faIcon + ", href=" + this.href + ", tooltip=" + this.tooltip + ", nestedCaption=" + this.nestedCaption + ", cssClasses=" + String.valueOf(this.cssClasses) + ")";
        }
    }
}

