/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.tabular;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public record TabularModel(Can<TabularSheet> sheets) {
    public TabularModel(TabularSheet sheet) {
        this(Can.of(sheet));
    }

    public record TabularSheet(String sheetName, Can<TabularColumn> columns, Can<TabularRow> rows) {
    }

    public record TabularRow(Can<TabularCell> cells) {
        public TabularCell getCell(TabularColumn column) {
            return this.getCell(column.columnIndex());
        }

        public TabularCell getCell(int columnIndex) {
            return this.cells.getElseFail(columnIndex);
        }
    }

    public record TabularCell(int cardinality, @NonNull Either<Object, Supplier<Stream<String>>> eitherValueOrLabelSupplier) {
        private static TabularCell EMPTY = new TabularCell(0, Either.right(Stream::empty));

        public TabularCell {
            Objects.requireNonNull(eitherValueOrLabelSupplier);
            if (cardinality < 0) {
                throw _Exceptions.illegalArgument("cardinality cannot be negative: %d", cardinality);
            }
            if (cardinality == 0) {
                _Assert.assertTrue(eitherValueOrLabelSupplier.isRight(), () -> "cannot provide a value when cardinality is zero");
            }
        }

        public static TabularCell empty() {
            return EMPTY;
        }

        public static TabularCell single(@Nullable Object value) {
            return value == null ? EMPTY : new TabularCell(1, Either.left(value));
        }

        public static TabularCell labeled(int cardinality, @NonNull Supplier<Stream<String>> labelSupplier) {
            Objects.requireNonNull(labelSupplier);
            return new TabularCell(cardinality, Either.right(labelSupplier));
        }

        public Stream<String> labels() {
            return this.eitherValueOrLabelSupplier.fold(left -> Stream.empty(), right -> (Stream)right.get());
        }
    }

    public record TabularColumn(int columnIndex, String columnName, String columnDescription) {
    }
}

