/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._Bytes_GZipCompressor;
import org.apache.causeway.commons.internal.exceptions._Exceptions;

final class _Bytes_GZipCompressorSmart {
    private static final int INPUT_LENGTH_THRESHOLD_FOR_SMART_COMPRESSION = 256;
    private static final int GZIP_MIN_OVERHEAD = 18;
    private static final byte COMPRESSION_NONE = 0;
    private static final byte COMPRESSION_GZIP = 1;

    static byte[] compress(byte[] input) throws IOException {
        if (input.length < 18) {
            return input;
        }
        if (input.length < 256) {
            return _Bytes.prepend(input, 0);
        }
        return _Bytes.prepend(_Bytes_GZipCompressor.compress(input), 1);
    }

    static byte[] decompress(byte[] input) throws IOException {
        if (input == null || input.length < 18) {
            return input;
        }
        byte[] inputWithoutPrefix = Arrays.copyOfRange(input, 1, input.length);
        return _Bytes_GZipCompressorSmart.isCompressed(input) ? _Bytes_GZipCompressor.decompress(inputWithoutPrefix) : inputWithoutPrefix;
    }

    private static boolean isCompressed(byte[] input) {
        switch (input[0]) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw _Exceptions.unmatchedCase(input[0]);
    }

    @Generated
    private _Bytes_GZipCompressorSmart() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

