/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.ioc;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public record _SingletonBeanProvider(@NonNull String id, @NonNull Class<?> beanClass, @NonNull Supplier<?> beanProvider) {
    public static <T> _SingletonBeanProvider forTestingLazy(String logicalTypeName, Class<T> beanClass, Supplier<T> beanProvider) {
        return new _SingletonBeanProvider(logicalTypeName, beanClass, beanProvider);
    }

    public static <T> _SingletonBeanProvider forTestingLazy(Class<T> beanClass, Supplier<T> beanProvider) {
        return new _SingletonBeanProvider(beanClass.getName(), beanClass, beanProvider);
    }

    public static <T> _SingletonBeanProvider forTesting(T bean) {
        return new _SingletonBeanProvider(bean.getClass().getName(), bean.getClass(), () -> bean);
    }

    public Optional<?> lookupInstance() {
        return Optional.ofNullable(this.beanProvider.get());
    }

    public Object getInstanceElseFail() {
        return this.lookupInstance().orElseThrow(() -> _Exceptions.noSuchElement("Cannot create bean instance for name '%s' (with required type %s)", this.id, this.beanClass.getName()));
    }

    public boolean isCandidateFor(@Nullable Class<?> requiredType) {
        if (requiredType == null) {
            return false;
        }
        return requiredType.isAssignableFrom(this.beanClass);
    }

    @Override
    public final boolean equals(Object obj) {
        boolean bl;
        if (obj instanceof _SingletonBeanProvider) {
            _SingletonBeanProvider other = (_SingletonBeanProvider)obj;
            bl = Objects.equals(this.id(), other.id()) && Objects.equals(this.beanClass(), other.beanClass());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.id, this.beanClass);
    }

    @Override
    public final String toString() {
        return "SingletonBeanProvider[id=%s, beanClass=%s]".formatted(this.id, this.beanClass);
    }

    public static Predicate<_SingletonBeanProvider> satisfying(Class<?> requiredType) {
        return singletonProvider -> singletonProvider.isCandidateFor(requiredType);
    }
}

