/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.commons.internal.reflection._Annotations_SynthesizedMergedAnnotationInvocationHandler;
import org.apache.causeway.commons.internal.reflection._ClassCacheUtil;
import org.apache.causeway.commons.internal.reflection._GenericResolver;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.apache.causeway.commons.semantics.AccessorSemantics;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.function.ThrowingConsumer;

public final class _ClassCache
implements AutoCloseable {
    private final @Nullable ClassLoader classLoader;
    private final Map<Class<?>, ClassModel> inspectedTypes = new HashMap();

    private static _ClassCache defaultInstance() {
        return new _ClassCache(_Context.getDefaultClassLoader());
    }

    public static _ClassCache getInstance() {
        return _Context.computeIfAbsent(_ClassCache.class, () -> _ClassCache.defaultInstance());
    }

    public static void invalidate() {
        _Context.put(_ClassCache.class, _ClassCache.defaultInstance(), true);
    }

    public void add(Class<?> type) {
        this.classModel(type);
    }

    public boolean isNamed(Class<?> type) {
        return this.classModel(type).head().named() != null;
    }

    public void setSpringNamed(Class<?> beanClass, String beanDefinitionName) {
        _Assert.assertNotEmpty(beanDefinitionName);
        this.head(beanClass).attributeMap().put(Attribute.SPRING_NAMED, beanDefinitionName);
    }

    public String getLogicalName(Class<?> type) {
        ClassModelHead head = this.head(type);
        return Optional.ofNullable(head.attributeMap().get((Object)Attribute.SPRING_NAMED)).or(() -> Optional.ofNullable(head.named())).or(() -> Optional.ofNullable(type.getCanonicalName())).orElseGet(type::getName);
    }

    public ClassModelHead head(Class<?> type) {
        return this.classModel(type).head();
    }

    private ClassModelBody body(Class<?> type) {
        return this.classModel(type).body();
    }

    public <T> Stream<_GenericResolver.ResolvedConstructor> streamPublicConstructors(Class<T> type) {
        return (Stream)_Casts.uncheckedCast(this.body(type).publicConstructorsByKey.values().stream());
    }

    public <T> Stream<_GenericResolver.ResolvedConstructor> streamPublicConstructorsWithInjectSemantics(Class<T> type) {
        return (Stream)_Casts.uncheckedCast(this.body(type).constructorsWithInjectSemanticsByKey.values().stream());
    }

    public Optional<_GenericResolver.ResolvedConstructor> lookupPublicConstructor(Class<?> type, Class<?>[] paramTypes) {
        return Optional.ofNullable(this.lookupConstructor(false, type, paramTypes));
    }

    public Stream<Method> streamPostConstructMethods(Class<?> type) {
        return this.body(type).postConstructMethodsByKey.values().stream().map(_GenericResolver.ResolvedMethod::method);
    }

    public Optional<_GenericResolver.ResolvedMethod> lookupPublicMethod(Class<?> type, String name, Class<?>[] paramTypes) {
        return Optional.ofNullable(this.findMethod(false, type, name, paramTypes));
    }

    public _GenericResolver.ResolvedMethod lookupPublicMethodElseFail(Class<?> type, String name, Class<?>[] paramTypes) {
        return this.lookupPublicMethod(type, name, paramTypes).orElseThrow(() -> _Exceptions.noSuchMethodException(type, name, paramTypes));
    }

    public Optional<_GenericResolver.ResolvedMethod> lookupResolvedMethod(Class<?> type, String name, Class<?>[] paramTypes) {
        return Optional.ofNullable(this.findMethod(true, type, name, paramTypes));
    }

    public _GenericResolver.ResolvedMethod lookupResolvedMethodElseFail(Class<?> type, String name, Class<?>[] paramTypes) {
        return this.lookupResolvedMethod(type, name, paramTypes).orElseThrow(() -> _Exceptions.noSuchMethodException(type, name, paramTypes));
    }

    public Stream<_GenericResolver.ResolvedMethod> streamPublicMethods(Class<?> type) {
        return this.body(type).publicMethodsByKey.values().stream();
    }

    public Stream<_GenericResolver.ResolvedMethod> streamResolvedMethods(Class<?> type) {
        return this.body(type).resolvedMethodsByKey.values().stream();
    }

    public _GenericResolver.ResolvedMethod findMethodUniquelyByNameOrFail(Class<?> type, String methodName) {
        Can matchingMethods = this.streamResolvedMethods(type).filter(method -> method.name().equals(methodName)).collect(Can.toCan());
        return matchingMethods.isCardinalityMultiple() ? (_GenericResolver.ResolvedMethod)matchingMethods.reduce(_GenericResolver.ResolvedMethod::mostSpecific).getSingleton().orElseThrow(() -> _Exceptions.illegalState("unable to determine most specific of methods %s", matchingMethods)) : (_GenericResolver.ResolvedMethod)matchingMethods.getSingleton().orElseThrow(() -> _Exceptions.noSuchMethodException(type, methodName, new Class[0]));
    }

    public Stream<Field> streamDeclaredFields(Class<?> type) {
        return this.body(type).declaredFields.stream();
    }

    public Optional<_GenericResolver.ResolvedMethod> getterForField(Class<?> type, Field field) {
        String capitalizedFieldName = _Strings.capitalize(field.getName());
        return Stream.of("get", "is").map(prefix -> prefix + capitalizedFieldName).map(methodName -> this.lookupResolvedMethod(type, (String)methodName, _Constants.emptyClasses).orElse(null)).filter(_NullSafe::isPresent).filter(resolvedMethod -> AccessorSemantics.isGetter(resolvedMethod)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<_GenericResolver.ResolvedMethod> streamDeclaredMethodsHaving(Class<?> type, String attributeName, Predicate<_GenericResolver.ResolvedMethod> filter) {
        ClassModel classModel = this.classModel(type);
        Map<String, Can<_GenericResolver.ResolvedMethod>> map = classModel.body().declaredMethodsByAttribute;
        synchronized (map) {
            return classModel.body().declaredMethodsByAttribute.computeIfAbsent(attributeName, key -> classModel.body().resolvedMethodsByKey.values().stream().filter(filter).collect(Can.toCan())).stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Map<Class<?>, ClassModel> map = this.inspectedTypes;
        synchronized (map) {
            this.inspectedTypes.clear();
        }
    }

    public static boolean methodExcludeFilter(Method method) {
        return method.isBridge() || Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().equals(Object.class) || _Reflect.isNonFinalObjectMethod(method) && !_Reflect.isOverwrittenToString(method);
    }

    public static boolean methodIncludeFilter(Method method) {
        return !_ClassCache.methodExcludeFilter(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassModel classModel(Class<?> type) {
        Map<Class<?>, ClassModel> map = this.inspectedTypes;
        synchronized (map) {
            return this.inspectedTypes.computeIfAbsent(type, this::inspectType);
        }
    }

    private Class<?> reloadType(Class<?> _type) {
        return Optional.ofNullable(this.classLoader).filter(cl -> !_type.isPrimitive()).filter(cl -> !_Reflect.isJavaApiClass(_type)).filter(cl -> !cl.equals(_type.getClassLoader())).map(cl -> Try.call(() -> Class.forName(_type.getName(), true, cl)).ifFailure((ThrowingConsumer<Throwable>)((ThrowingConsumer)e -> System.err.printf("ClassCache: reloading of type %s failed with %s%n", _type.getName(), e))).getValue().orElse(null)).orElse(_type);
    }

    private ClassModel inspectType(Class<?> _type) {
        Class<?> type = this.reloadType(_type);
        ClassModelHead head = ClassModelHead.create(type);
        return new ClassModel(head, _Lazy.threadSafe(() -> ClassModelBody.create(type, head)));
    }

    private static _GenericResolver.ResolvedMethod putIntoMapHonoringOverridingRelation(Map<MethodKey, _GenericResolver.ResolvedMethod> map, MethodKey key, _GenericResolver.ResolvedMethod method) {
        _GenericResolver.ResolvedMethod methodWithSameKey = map.get(key);
        _GenericResolver.ResolvedMethod methodToKeep = methodWithSameKey == null ? method : methodWithSameKey.mostSpecific(method);
        map.put(key, methodToKeep);
        Can weaklySame = map.values().stream().filter(m -> _GenericResolver.ResolvedMethod.methodsWeaklySame(methodToKeep, m)).collect(Can.toCan());
        if (weaklySame.isCardinalityMultiple()) {
            map.values().removeIf(weaklySame::contains);
            _GenericResolver.ResolvedMethod winner = (_GenericResolver.ResolvedMethod)weaklySame.reduce(_GenericResolver.ResolvedMethod::mostSpecific).getSingletonOrFail();
            MethodKey winnerKey = new MethodKey(winner.implementationClass(), winner.method());
            map.put(winnerKey, winner);
            return winner;
        }
        return methodToKeep;
    }

    private static boolean isInjectSemantics(Constructor<?> con) {
        return _Annotations.synthesize(con, Inject.class).isPresent() || _Annotations.synthesize(con, Autowired.class).map(annot -> annot.required()).orElse(false) != false;
    }

    private static boolean isPostConstruct(Method method) {
        return Void.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0 ? _Annotations.synthesize(method, PostConstruct.class).isPresent() : false;
    }

    private _GenericResolver.ResolvedConstructor lookupConstructor(boolean includeDeclaredConstructors, Class<?> type, Class<?>[] paramTypes) {
        ClassModel model = this.classModel(type);
        ConstructorKey key = new ConstructorKey(type, paramTypes);
        _GenericResolver.ResolvedConstructor publicConstructor = model.body().publicConstructorsByKey.get(key);
        return publicConstructor;
    }

    private @Nullable _GenericResolver.ResolvedMethod findMethod(boolean includeDeclaredMethods, Class<?> type, String name, Class<?>[] requiredParamTypes) {
        ClassModel model = this.classModel(type);
        _GenericResolver.ResolvedMethod publicMethod = model.body().publicMethodsByKey.values().stream().filter(m -> m.name().equals(name)).filter(m -> _Reflect.methodSignatureAssignableTo(m.paramTypes(), requiredParamTypes)).findFirst().orElse(null);
        if (publicMethod != null) {
            return publicMethod;
        }
        if (includeDeclaredMethods) {
            _GenericResolver.ResolvedMethod resolvedMethod = model.body().resolvedMethodsByKey.values().stream().filter(m -> m.name().equals(name)).filter(m -> _Reflect.methodSignatureAssignableTo(m.paramTypes(), requiredParamTypes)).findFirst().orElse(null);
            return resolvedMethod;
        }
        return null;
    }

    @Generated
    private _ClassCache(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private record ClassModel(ClassModelHead head, _Lazy<ClassModelBody> lazyBody) {
        ClassModelBody body() {
            return this.lazyBody.get();
        }
    }

    public record ClassModelHead(MergedAnnotations mergedAnnotations, @Nullable String named, Map<Attribute, String> attributeMap) {
        static ClassModelHead create(Class<?> type) {
            MergedAnnotations mergedAnnotations = MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
            return new ClassModelHead(mergedAnnotations, _ClassCacheUtil.inferName(type, mergedAnnotations), new ConcurrentHashMap<Attribute, String>());
        }

        public <A extends Annotation> Optional<A> annotation(Class<A> annotationType) {
            return _Annotations_SynthesizedMergedAnnotationInvocationHandler.createProxy(this.mergedAnnotations, Optional.empty(), annotationType);
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.mergedAnnotations.get(annotationType).isPresent();
        }

        public boolean hasJaxbRootElementSemantics() {
            return this.hasAnnotation(XmlRootElement.class);
        }

        public boolean isJdoPersistenceCapable() {
            return _ClassCacheUtil.isJdoPersistenceCapable(this.mergedAnnotations) && !_ClassCacheUtil.isJdoEmbeddedOnly(this.mergedAnnotations);
        }

        public Can<String> springProfiles() {
            MergedAnnotation profileAnnot = this.mergedAnnotations.get(Profile.class);
            if (!profileAnnot.isPresent()) {
                return Can.empty();
            }
            return Can.ofArray(profileAnnot.getStringArray("value"));
        }
    }

    public static enum Attribute {
        SPRING_NAMED,
        MIXIN_MAIN_METHOD_NAME;

    }

    private record ClassModelBody(Can<Field> declaredFields, Map<ConstructorKey, _GenericResolver.ResolvedConstructor> publicConstructorsByKey, Map<ConstructorKey, _GenericResolver.ResolvedConstructor> constructorsWithInjectSemanticsByKey, Map<MethodKey, _GenericResolver.ResolvedMethod> resolvedMethodsByKey, Map<MethodKey, _GenericResolver.ResolvedMethod> publicMethodsByKey, Map<MethodKey, _GenericResolver.ResolvedMethod> postConstructMethodsByKey, Map<String, Can<_GenericResolver.ResolvedMethod>> declaredMethodsByAttribute) {
        ClassModelBody(Can<Field> declaredFields) {
            this(declaredFields, new HashMap<ConstructorKey, _GenericResolver.ResolvedConstructor>(), new HashMap<ConstructorKey, _GenericResolver.ResolvedConstructor>(), new HashMap<MethodKey, _GenericResolver.ResolvedMethod>(), new HashMap<MethodKey, _GenericResolver.ResolvedMethod>(), new HashMap<MethodKey, _GenericResolver.ResolvedMethod>(), new HashMap<String, Can<_GenericResolver.ResolvedMethod>>());
        }

        private static ClassModelBody create(Class<?> type, ClassModelHead head) {
            ClassModelBody body = new ClassModelBody(Can.ofArray(type.getDeclaredFields()));
            if (type.isRecord()) {
                Constructor<?>[] declaredConstr;
                for (Constructor<?> constr : declaredConstr = type.getDeclaredConstructors()) {
                    if (Modifier.isPrivate(constr.getModifiers())) continue;
                    ConstructorKey key = new ConstructorKey(type, constr);
                    _GenericResolver.ResolvedConstructor resolvedConstr = _GenericResolver.resolveConstructor(constr, type);
                    body.publicConstructorsByKey.put(key, resolvedConstr);
                    if (!_ClassCache.isInjectSemantics(constr)) continue;
                    body.constructorsWithInjectSemanticsByKey.put(key, resolvedConstr);
                }
            } else {
                Constructor<?>[] publicConstr;
                for (Constructor<?> constr : publicConstr = type.getConstructors()) {
                    ConstructorKey key = new ConstructorKey(type, constr);
                    _GenericResolver.ResolvedConstructor resolvedConstr = _GenericResolver.resolveConstructor(constr, type);
                    body.publicConstructorsByKey.put(key, resolvedConstr);
                    if (!_ClassCache.isInjectSemantics(constr)) continue;
                    body.constructorsWithInjectSemanticsByKey.put(key, resolvedConstr);
                }
            }
            _Reflect.streamAllMethods(type, true).filter(_ClassCache::methodIncludeFilter).map(method -> _GenericResolver.resolveMethod(method, type).orElse(null)).filter(_NullSafe::isPresent).forEach(resolved -> {
                MethodKey key = new MethodKey(type, resolved.method());
                _GenericResolver.ResolvedMethod methodToKeep = _ClassCache.putIntoMapHonoringOverridingRelation(body.resolvedMethodsByKey, key, resolved);
                if (_ClassCache.isPostConstruct(methodToKeep.method())) {
                    body.postConstructMethodsByKey.put(key, methodToKeep);
                }
            });
            _NullSafe.stream(type.getMethods()).filter(_ClassCache::methodIncludeFilter).map(method -> _GenericResolver.resolveMethod(method, type).orElse(null)).filter(_NullSafe::isPresent).forEach(resolved -> {
                MethodKey key = new MethodKey(type, resolved.method());
                _ClassCache.putIntoMapHonoringOverridingRelation(body.publicMethodsByKey, key, resolved);
            });
            return body;
        }
    }

    private record MethodKey(Class<?> implementingClass, String name, @Nullable Class<?>[] paramTypes) {
        MethodKey(Class<?> implementingClass, String name, Class<?>[] paramTypes) {
            this.implementingClass = implementingClass;
            this.name = name;
            this.paramTypes = _Arrays.emptyToNull(paramTypes);
        }

        MethodKey(Class<?> type, Method method) {
            this(type, method.getName(), method.getParameterTypes());
        }
    }

    private record ConstructorKey(Class<?> type, @Nullable Class<?>[] paramTypes) {
        ConstructorKey(Class<?> type, Class<?>[] paramTypes) {
            this.type = type;
            this.paramTypes = _Arrays.emptyToNull(paramTypes);
        }

        ConstructorKey(Class<?> type, Constructor<?> constructor) {
            this(type, constructor.getParameterTypes());
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public final boolean equals(Object o) {
            boolean bl;
            if (o instanceof ConstructorKey) {
                ConstructorKey other = (ConstructorKey)o;
                bl = this.type.equals(other.type) && Arrays.equals(this.paramTypes, other.paramTypes());
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

