/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.ref;

import java.io.Serializable;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class TransientObjectRef<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient @Nullable T object;
    private transient boolean updating;

    public TransientObjectRef(@Nullable T object) {
        this.object = object;
    }

    public T computeIfAbsent(Supplier<T> supplier) {
        return this.object != null ? this.object : this.update(__ -> supplier.get());
    }

    public T update(UnaryOperator<T> updater) {
        if (this.updating) {
            throw new UnsupportedOperationException("nested call to update detected");
        }
        this.updating = true;
        try {
            this.object = updater.apply(this.object);
        }
        finally {
            this.updating = false;
        }
        return this.object;
    }

    public String toString() {
        return "TransientObjectRef[%s]".formatted(this.object != null ? "PRESENT" : "EMPTY");
    }

    @Generated
    public @Nullable T getObject() {
        return this.object;
    }
}

