/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.Cardinality;
import org.apache.causeway.commons.collections._CanFactory;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Objects;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

record Can_Singleton<T>(T element) implements Can<T>
{
    @Override
    public Optional<T> getSingleton() {
        return Optional.of(this.element);
    }

    @Override
    public Cardinality getCardinality() {
        return Cardinality.ONE;
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.element);
    }

    @Override
    public Stream<T> parallelStream() {
        return Stream.of(this.element);
    }

    @Override
    public Optional<T> getFirst() {
        return this.getSingleton();
    }

    @Override
    public Optional<T> getLast() {
        return this.getSingleton();
    }

    @Override
    public Optional<T> get(int elementIndex) {
        return this.getSingleton();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@Nullable T element) {
        return Objects.equals(this.element, element);
    }

    @Override
    public Iterator<T> iterator(int skip, int limit) {
        return skip < 1 && limit > 0 ? this.iterator() : Collections.emptyList().iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.singletonList(this.element).iterator();
    }

    @Override
    public Can<T> sorted(@NonNull Comparator<? super T> c) {
        return this;
    }

    @Override
    public Can<T> distinct() {
        return this;
    }

    @Override
    public Can<T> distinct(@NonNull BiPredicate<T, T> equality) {
        return this;
    }

    @Override
    public Can<T> reverse() {
        return this;
    }

    @Override
    public Iterator<T> reverseIterator() {
        return this.iterator();
    }

    @Override
    public Can<T> reduce(@NonNull BinaryOperator<T> accumulator) {
        return this;
    }

    @Override
    public void forEach(@NonNull Consumer<? super T> action) {
        action.accept(this.element);
    }

    @Override
    public Can<T> filter(@Nullable Predicate<? super T> predicate) {
        if (predicate == null) {
            return this;
        }
        return predicate.test(this.element) ? this : Can.empty();
    }

    @Override
    public <R> void zip(Iterable<R> zippedIn, BiConsumer<? super T, ? super R> action) {
        action.accept(this.element, zippedIn.iterator().next());
    }

    @Override
    public <R, Z> Can<R> zipMap(Iterable<Z> zippedIn, BiFunction<? super T, ? super Z, R> mapper) {
        R next = mapper.apply(this.element, zippedIn.iterator().next());
        return next != null ? new Can_Singleton<R>(next) : Can.empty();
    }

    @Override
    public <R, Z> Stream<R> zipStream(@NonNull Iterable<Z> zippedIn, BiFunction<? super T, ? super Z, R> mapper) {
        R next = mapper.apply(this.element, zippedIn.iterator().next());
        return next != null ? Stream.of(next) : Stream.empty();
    }

    @Override
    public Can<T> add(@Nullable T element) {
        return element != null ? Can.ofStream(Stream.of(this.element, element)) : this;
    }

    @Override
    public Can<T> addAll(@Nullable Can<T> other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (other.isCardinalityOne()) {
            return this.add(other.getSingleton().orElseThrow(_Exceptions::unexpectedCodeReach));
        }
        ArrayList<T> newElements = new ArrayList<T>(other.size() + 1);
        newElements.add(this.element);
        other.forEach(newElements::add);
        return _CanFactory.ofNonNullElements(newElements);
    }

    @Override
    public Can<T> add(int index, @Nullable T element) {
        if (element == null) {
            return this;
        }
        if (index == 0) {
            return Can.ofStream(Stream.of(element, this.element));
        }
        if (index == 1) {
            return Can.ofStream(Stream.of(this.element, element));
        }
        throw new IndexOutOfBoundsException("cannot add to singleton with index other than 0 or 1; got " + index);
    }

    @Override
    public Can<T> replace(int index, @Nullable T element) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("cannot replace on singleton with index other than 0; got " + index);
        }
        return element != null ? Can.ofSingleton(element) : Can.empty();
    }

    @Override
    public Can<T> remove(int index) {
        if (index == 0) {
            return Can.empty();
        }
        throw new IndexOutOfBoundsException("cannot remove from singleton with index other than 0; got " + index);
    }

    @Override
    public Can<T> remove(@Nullable T element) {
        if (this.element.equals(element)) {
            return Can.empty();
        }
        return this;
    }

    @Override
    public Can<T> pickByIndex(int ... indices) {
        if (indices == null || indices.length == 0) {
            return Can.empty();
        }
        int pickCount = 0;
        for (int index : indices) {
            if (index != 0) continue;
            ++pickCount;
        }
        if (pickCount == 0) {
            return Can.empty();
        }
        if (pickCount == 1) {
            return this;
        }
        ArrayList<T> newElements = new ArrayList<T>(pickCount);
        for (int i = 0; i < pickCount; ++i) {
            newElements.add(this.element);
        }
        return _CanFactory.ofNonNullElements(newElements);
    }

    @Override
    public Can<T> pickByIndex(@Nullable IntStream intStream) {
        if (intStream == null) {
            return Can.empty();
        }
        long pickCountL = intStream.filter((int index) -> index == 0).count();
        if (pickCountL == 0L) {
            return Can.empty();
        }
        if (pickCountL == 1L) {
            return this;
        }
        if (pickCountL > Integer.MAX_VALUE) {
            throw _Exceptions.illegalArgument("pickCount %d is too large to fit into an int", pickCountL);
        }
        int pickCount = (int)pickCountL;
        ArrayList<T> newElements = new ArrayList<T>(pickCount);
        for (int i = 0; i < pickCount; ++i) {
            newElements.add(this.element);
        }
        return _CanFactory.ofNonNullElements(newElements);
    }

    @Override
    public Can<T> subCan(int startInclusive) {
        return startInclusive <= 0 ? this : Can.empty();
    }

    @Override
    public Can<T> subCan(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return Can.empty();
        }
        return startInclusive <= 0 && endExclusive > 0 ? this : Can.empty();
    }

    @Override
    public Can<Can<T>> partitionInnerBound(int maxInnerSize) {
        if (maxInnerSize < 1) {
            throw _Exceptions.illegalArgument("maxInnerSize %d must be greater or equal to 1", maxInnerSize);
        }
        return Can.of(this);
    }

    @Override
    public Can<Can<T>> partitionOuterBound(int outerSizeYield) {
        if (outerSizeYield < 1) {
            throw _Exceptions.illegalArgument("outerSizeYield %d must be greater or equal to 1", outerSizeYield);
        }
        return Can.of(this);
    }

    @Override
    public int indexOf(@Nullable T element) {
        return this.element.equals(element) ? 0 : -1;
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return predicate.test(this.element);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return predicate.test(this.element);
    }

    @Override
    public String toString() {
        return "Can[" + String.valueOf(this.element) + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Can) {
            return ((Can)obj).isEqualTo(this);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public int compareTo(@Nullable Can<T> other) {
        if (other == null || other.isEmpty()) {
            return 1;
        }
        int firstElementComparison = _Objects.compareNonNull(this.element, other.getFirstElseFail());
        if (firstElementComparison != 0 || other.isCardinalityOne()) {
            return firstElementComparison;
        }
        return -1;
    }

    @Override
    public List<T> toList() {
        return Collections.singletonList(this.element);
    }

    @Override
    public List<T> toArrayList() {
        ArrayList list = _Lists.newArrayList();
        list.add(this.element);
        return list;
    }

    @Override
    public Set<T> toSet() {
        return Collections.singleton(this.element);
    }

    @Override
    public Set<T> toSet(@NonNull Consumer<T> onDuplicated) {
        return Collections.singleton(this.element);
    }

    @Override
    public T[] toArray(@NonNull Class<T> elementType) {
        Object[] array = (Object[])_Casts.uncheckedCast(Array.newInstance(elementType, 1));
        array[0] = this.element;
        return array;
    }

    @Override
    public <K> Map<K, T> toMap(@NonNull Function<? super T, ? extends K> keyExtractor) {
        return Map.of(keyExtractor.apply(this.element), this.element);
    }

    @Override
    public <K, M extends Map<K, T>> Map<K, T> toMap(@NonNull Function<? super T, ? extends K> keyExtractor, @NonNull BinaryOperator<T> mergeFunction, @NonNull Supplier<M> mapFactory) {
        return this.toMap(keyExtractor);
    }

    @Override
    public <R, A> R collect(@NonNull Collector<? super T, A, R> collector) {
        A container = collector.supplier().get();
        collector.accumulator().accept(container, this.element);
        return collector.finisher().apply(container);
    }

    @Override
    public <K> Map<K, Can<T>> groupBy(@NonNull Function<? super T, ? extends K> classifier) {
        return Map.of(classifier.apply(this.element), this);
    }

    @Override
    public <K, M extends Map<K, Can<T>>> Map<K, Can<T>> groupBy(@NonNull Function<? super T, ? extends K> classifier, @NonNull Supplier<M> mapFactory) {
        return this.groupBy(classifier);
    }

    @Override
    public String join(@NonNull String delimiter) {
        String str = this.element.toString();
        return str != null ? str : "";
    }

    @Override
    public String join(@NonNull Function<? super T, String> toStringFunction, @NonNull String delimiter) {
        String str = toStringFunction.apply(this.element);
        return str != null ? str : "";
    }
}

