/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.proxy;

import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.causeway.commons.internal.proxy.CachableInvocationHandler;
import org.apache.causeway.commons.internal.proxy.ProxyFactory;
import org.apache.causeway.commons.internal.proxy.ProxyFactoryService;
import org.jspecify.annotations.Nullable;

public abstract class CachingProxyFactoryService
implements ProxyFactoryService {
    private final Map<Class<?>, ProxyFactory<?>> proxyFactoryCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, Class<?>> proxyClassCache = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public final <T> Class<? extends T> proxyClass(InvocationHandler handler, Class<T> base, Class<?>[] interfaces, @Nullable List<ProxyFactoryService.AdditionalField> additionalFields) {
        Class clazz;
        if (handler instanceof CachableInvocationHandler) {
            CachableInvocationHandler cachableInvocationHandler = (CachableInvocationHandler)handler;
            clazz = this.proxyClassCache.computeIfAbsent(cachableInvocationHandler.key(), __ -> this.createProxyClass(handler, base, interfaces, additionalFields));
        } else {
            clazz = this.createProxyClass(handler, base, interfaces, additionalFields);
        }
        Class proxyClass = clazz;
        return proxyClass;
    }

    @Override
    public final <T> ProxyFactory<T> factory(Class<T> proxyClass, @Nullable Class<?>[] constructorArgTypes) {
        ProxyFactory factory = this.proxyFactoryCache.computeIfAbsent(proxyClass, __ -> this.createFactory(proxyClass, constructorArgTypes));
        return factory;
    }

    protected abstract <T> Class<? extends T> createProxyClass(InvocationHandler var1, Class<T> var2, Class<?>[] var3, @Nullable List<ProxyFactoryService.AdditionalField> var4);

    protected abstract <T> ProxyFactory<T> createFactory(Class<T> var1, @Nullable Class<?>[] var2);
}

