/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.commons.internal.reflection._Annotations_SynthesizedMergedAnnotationInvocationHandler;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.springframework.core.annotation.MergedAnnotations;

public final class _Annotations {
    public static <A extends Annotation> boolean isPresent(AnnotatedElement annotatedElement, Class<A> annotationType) {
        MergedAnnotations collected = _Annotations.collect(annotatedElement, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        if (collected.isPresent(annotationType)) {
            return true;
        }
        return _Annotations.annotatedFieldForAnnotatedElement(annotatedElement, annotationType).map(fieldForGetter -> _Annotations.isPresent(fieldForGetter, annotationType)).orElse(false);
    }

    public static <A extends Annotation> Optional<A> synthesize(AnnotatedElement annotatedElement, Class<A> annotationType) {
        MergedAnnotations collected = _Annotations.collect(annotatedElement, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        Optional<MergedAnnotations> associated = _Annotations.annotatedFieldForAnnotatedElement(annotatedElement, annotationType).map(fieldForGetter -> _Annotations.collect(fieldForGetter, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
        return _Annotations_SynthesizedMergedAnnotationInvocationHandler.createProxy(collected, associated, annotationType);
    }

    public static <A extends Annotation> Optional<A> synthesizeConsideringClass(Method annotatedMethod, Class<A> annotationType) {
        MergedAnnotations collected = _Annotations.collect(annotatedMethod, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotations associatedClass = _Annotations.collect(annotatedMethod.getDeclaringClass(), MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        return _Annotations_SynthesizedMergedAnnotationInvocationHandler.createProxy(collected, Optional.of(associatedClass), annotationType);
    }

    public static <A extends Annotation> Optional<A> synthesizeDirect(AnnotatedElement annotatedElement, Class<A> annotationType) {
        MergedAnnotations collected = _Annotations.collect(annotatedElement, MergedAnnotations.SearchStrategy.DIRECT);
        Optional<MergedAnnotations> associated = _Annotations.annotatedFieldForAnnotatedElement(annotatedElement, annotationType).map(fieldForGetter -> _Annotations.collect(fieldForGetter, MergedAnnotations.SearchStrategy.DIRECT));
        return _Annotations_SynthesizedMergedAnnotationInvocationHandler.createProxy(collected, associated, annotationType);
    }

    private static MergedAnnotations collect(AnnotatedElement annotatedElement, MergedAnnotations.SearchStrategy searchStrategy) {
        MergedAnnotations collected = MergedAnnotations.from((AnnotatedElement)annotatedElement, (MergedAnnotations.SearchStrategy)searchStrategy);
        return collected;
    }

    private static boolean isAnnotationAllowedOnField(Class<? extends Annotation> annotationType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        for (ElementType elementType : target.value()) {
            if (elementType != ElementType.FIELD) continue;
            return true;
        }
        return false;
    }

    private static <A extends Annotation> Optional<Field> annotatedFieldForAnnotatedElement(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return annotatedElement instanceof Method ? _Annotations.annotatedFieldForGetter((Method)annotatedElement, annotationType) : Optional.empty();
    }

    private static <A extends Annotation> Optional<Field> annotatedFieldForGetter(Method method, Class<A> annotationType) {
        return (method.getName().startsWith("get") || method.getName().startsWith("is")) && _Annotations.isAnnotationAllowedOnField(annotationType) ? _Reflect.fieldForGetter(method) : Optional.empty();
    }

    @Generated
    private _Annotations() {
    }
}

