/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.jspecify.annotations.NonNull;

public final class _Serializables {
    public static byte[] write(@NonNull Serializable object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(65536);
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(object);
            oos.flush();
        }
        return bos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T read(@NonNull Class<T> requiredClass, @NonNull InputStream trustedContent) {
        try (ObjectInputStream ois = new ObjectInputStream(trustedContent);){
            Object pojo = ois.readObject();
            if (!requiredClass.isAssignableFrom(pojo.getClass())) {
                throw _Exceptions.unrecoverable("de-serializion of input stream did not yield an object of required type %s", requiredClass.getName());
            }
            Serializable serializable = (Serializable)_Casts.uncheckedCast(pojo);
            return (T)serializable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T read(@NonNull Class<T> requiredClass, @NonNull byte[] trustedBytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(trustedBytes);){
            T t = _Serializables.read(requiredClass, bis);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T readWithCustomClassLoader(@NonNull Class<T> requiredClass, final @NonNull ClassLoader classLoader, @NonNull byte[] trustedBytes) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(trustedBytes)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return Class.forName(desc.getName(), false, classLoader);
            }
        };){
            Object pojo = ois.readObject();
            if (!requiredClass.isAssignableFrom(pojo.getClass())) {
                throw _Exceptions.unrecoverable("de-serializion of input stream did not yield an object of required type %s", requiredClass.getName());
            }
            Serializable serializable = (Serializable)_Casts.uncheckedCast(pojo);
            return (T)serializable;
        }
    }

    @Generated
    private _Serializables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

