/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.commons.integration.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Named;
import lombok.NonNull;
import org.apache.causeway.applib.exceptions.unrecoverable.PersistFailedException;
import org.apache.causeway.applib.exceptions.unrecoverable.RepositoryException;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.query.QueryRange;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.repository.EntityState;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.applib.services.wrapper.WrapperFactory;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.MmEntityUtils;
import org.apache.causeway.core.metamodel.object.MmUnwrapUtils;
import org.apache.causeway.core.metamodel.objectmanager.ObjectBulkLoader;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.runtime.flushmgmt.FlushMgmt;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.persistence.commons.RepositoryServiceDefault")
@Priority(value=0x1FFFFFFF)
@Qualifier(value="Default")
public class RepositoryServiceDefault
implements RepositoryService,
HasMetaModelContext {
    final FactoryService factoryService;
    final WrapperFactory wrapperFactory;
    final TransactionService transactionService;
    final CausewayConfiguration causewayConfiguration;
    final MetaModelContext metaModelContext;
    private boolean autoFlush;

    @PostConstruct
    public void init() {
        boolean disableAutoFlush = this.causewayConfiguration.getPersistence().getCommons().getRepositoryService().isDisableAutoFlush() || this.causewayConfiguration.getCore().getRuntimeServices().getRepositoryService().isDisableAutoFlush();
        this.autoFlush = !disableAutoFlush;
    }

    public EntityState getEntityState(@Nullable Object object) {
        ManagedObject adapter = this.getObjectManager().adapt(this.unwrapped(object));
        return MmEntityUtils.getEntityState((ManagedObject)adapter);
    }

    public <T> T detachedEntity(@NonNull T entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return (T)this.factoryService.detachedEntity(entity);
    }

    public <T> T persist(T domainObject) {
        ManagedObject adapter = this.getObjectManager().adapt(this.unwrapped(domainObject));
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)adapter)) {
            throw new PersistFailedException("Object not known to framework (unable to create/obtain an adapter)");
        }
        EntityState entityState = MmEntityUtils.getEntityState((ManagedObject)adapter);
        if (!entityState.isPersistable() || entityState.isAttached()) {
            return domainObject;
        }
        MmEntityUtils.persistInCurrentTransaction((ManagedObject)adapter);
        return domainObject;
    }

    public <T> T persistAndFlush(T object) {
        this.persist(object);
        this.transactionService.flushTransaction();
        return object;
    }

    public void remove(Object domainObject) {
        if (domainObject == null) {
            return;
        }
        ManagedObject adapter = this.getObjectManager().adapt(this.unwrapped(domainObject));
        if (MmEntityUtils.getEntityState((ManagedObject)adapter).hasOid()) {
            MmEntityUtils.deleteInCurrentTransaction((ManagedObject)adapter);
        }
    }

    public void removeAndFlush(Object domainObject) {
        this.remove(domainObject);
        this.transactionService.flushTransaction();
    }

    public <T> List<T> allInstances(Class<T> type) {
        return this.allMatches(Query.allInstances(type));
    }

    public <T> List<T> allInstances(Class<T> type, long start, long count) {
        return this.allMatches(Query.allInstances(type).withRange(QueryRange.of((long[])new long[]{start, count})));
    }

    public <T> List<T> allMatches(Class<T> ofType, Predicate<? super T> predicate) {
        return this.allMatches(ofType, predicate, 0L, Long.MAX_VALUE);
    }

    public <T> List<T> allMatches(Class<T> ofType, Predicate<? super T> predicate, long start, long count) {
        return _NullSafe.stream(this.allInstances(ofType, start, count)).filter(predicate).collect(Collectors.toCollection(ArrayList::new));
    }

    public <T> List<T> allMatches(Query<T> query) {
        if (this.autoFlush && !FlushMgmt.isAutoFlushSuppressed()) {
            this.transactionService.flushTransaction();
        }
        return this.submitQuery(query);
    }

    <T> List<T> submitQuery(Query<T> query) {
        ObjectSpecification resultTypeSpec = this.getSpecificationLoader().specForType(query.getResultType()).orElse(null);
        if (resultTypeSpec == null) {
            return Collections.emptyList();
        }
        ObjectBulkLoader.Request queryRequest = ObjectBulkLoader.Request.of((ObjectSpecification)resultTypeSpec, query);
        Can allMatching = this.getObjectManager().queryObjects(queryRequest);
        List resultList = (List)_Casts.uncheckedCast((Object)MmUnwrapUtils.multipleAsList((Can)allMatching));
        return resultList;
    }

    public <T> Optional<T> uniqueMatch(Class<T> type, Predicate<T> predicate) {
        List<T> instances = this.allMatches(type, predicate);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + predicate);
        }
        return RepositoryServiceDefault.firstInstanceElseEmpty(instances);
    }

    public <T> Optional<T> uniqueMatch(Query<T> query) {
        List<T> instances = this.allMatches(query);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance for query:" + query.getDescription());
        }
        return RepositoryServiceDefault.firstInstanceElseEmpty(instances);
    }

    public <T> Optional<T> firstMatch(Class<T> type, Predicate<T> predicate) {
        List<T> instances = this.allMatches(type, predicate);
        return RepositoryServiceDefault.firstInstanceElseEmpty(instances);
    }

    public <T> Optional<T> firstMatch(Query<T> query) {
        List<T> instances = this.allMatches(query);
        return RepositoryServiceDefault.firstInstanceElseEmpty(instances);
    }

    public <T> T refresh(T entity) {
        if (entity == null) {
            return null;
        }
        this.getSpecificationLoader().specForType(entity.getClass()).flatMap(ObjectSpecification::entityFacet).ifPresent(entityFacet -> entityFacet.refresh(entity));
        return entity;
    }

    public <T> T detach(T entity) {
        if (entity == null) {
            return null;
        }
        return (T)this.getSpecificationLoader().specForType(entity.getClass()).flatMap(ObjectSpecification::entityFacet).map(entityFacet -> entityFacet.detach(entity)).map(detachedEntity -> detachedEntity == entity ? detachedEntity : this.getServiceInjector().injectServicesInto(detachedEntity)).orElse(entity);
    }

    public <T> void removeAll(Class<T> cls) {
        this.allInstances(cls).forEach(this::remove);
    }

    private static <T> Optional<T> firstInstanceElseEmpty(List<T> instances) {
        return instances.size() == 0 ? Optional.empty() : Optional.of(instances.get(0));
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    public RepositoryServiceDefault(FactoryService factoryService, WrapperFactory wrapperFactory, TransactionService transactionService, CausewayConfiguration causewayConfiguration, MetaModelContext metaModelContext) {
        this.factoryService = factoryService;
        this.wrapperFactory = wrapperFactory;
        this.transactionService = transactionService;
        this.causewayConfiguration = causewayConfiguration;
        this.metaModelContext = metaModelContext;
    }

    public MetaModelContext getMetaModelContext() {
        return this.metaModelContext;
    }
}

