/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import java.lang.reflect.Constructor;
import java.util.Map;
import javax.annotation.Priority;
import lombok.NonNull;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.datanucleus.identity.DatastoreId;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x60000063)
public class JdoDatastoreIdValueSemantics
extends ValueSemanticsBasedOnIdStringifier<DatastoreId> {
    public JdoDatastoreIdValueSemantics() {
        super(DatastoreId.class);
    }

    public ValueDecomposition decompose(DatastoreId value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", DatastoreId::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public DatastoreId compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull DatastoreId value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return value.getClass().getName() + "_" + value.toString();
    }

    public DatastoreId destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        int idx = stringified.indexOf(95);
        String clsName = stringified.substring(0, idx);
        String keyStr = stringified.substring(idx + 1);
        Class cls = _Context.loadClass((String)clsName);
        Constructor cons = cls.getConstructor(String.class);
        Object dnOid = cons.newInstance(keyStr);
        return (DatastoreId)_Casts.uncheckedCast(dnOid);
    }
}

