/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.sql.DataSource;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.beans.CausewayBeanTypeRegistry;
import org.apache.causeway.core.config.beans.aoppatch.TransactionInterceptorFactory;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.services.objectlifecycle.ObjectLifecyclePublisher;
import org.apache.causeway.persistence.jdo.datanucleus.changetracking.JdoLifecycleListener;
import org.apache.causeway.persistence.jdo.datanucleus.changetracking.PreAndPostValueEvaluatorServiceJdo;
import org.apache.causeway.persistence.jdo.datanucleus.config.DatanucleusSettings;
import org.apache.causeway.persistence.jdo.datanucleus.dialect.DnJdoDialect;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnEntityStateProvider;
import org.apache.causeway.persistence.jdo.datanucleus.exrecog.JdoObjectNotFoundRecognizer;
import org.apache.causeway.persistence.jdo.datanucleus.jdosupport.JdoSupportServiceDefault;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnByteIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnCharIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnDatastoreIdImplValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnDatastoreUniqueLongIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnIntIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnLongIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnObjectIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnScoidValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnShortIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.DnStringIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoByteIdentityValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoCharIdentityValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoDatastoreIdValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoIntIdentityValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoLongIdentityValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoObjectIdentityValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoShortIdentityValueSemantics;
import org.apache.causeway.persistence.jdo.datanucleus.valuetypes.JdoStringIdentityValueSemantics;
import org.apache.causeway.persistence.jdo.integration.CausewayModulePersistenceJdoIntegration;
import org.apache.causeway.persistence.jdo.provider.config.JdoEntityDiscoveryListener;
import org.apache.causeway.persistence.jdo.spring.integration.JdoDialect;
import org.apache.causeway.persistence.jdo.spring.integration.JdoTransactionManager;
import org.apache.causeway.persistence.jdo.spring.integration.LocalPersistenceManagerFactoryBean;
import org.apache.causeway.persistence.jdo.spring.integration.TransactionAwarePersistenceManagerFactoryProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@Import(value={CausewayModulePersistenceJdoIntegration.class, DnEntityStateProvider.class, DnDatastoreIdImplValueSemantics.class, DnDatastoreUniqueLongIdValueSemantics.class, JdoDatastoreIdValueSemantics.class, JdoShortIdentityValueSemantics.class, JdoLongIdentityValueSemantics.class, JdoIntIdentityValueSemantics.class, JdoByteIdentityValueSemantics.class, JdoCharIdentityValueSemantics.class, JdoStringIdentityValueSemantics.class, JdoObjectIdentityValueSemantics.class, DnShortIdValueSemantics.class, DnLongIdValueSemantics.class, DnIntIdValueSemantics.class, DnByteIdValueSemantics.class, DnCharIdValueSemantics.class, DnStringIdValueSemantics.class, DnObjectIdValueSemantics.class, DnScoidValueSemantics.class, JdoSupportServiceDefault.class, JdoObjectNotFoundRecognizer.class, PreAndPostValueEvaluatorServiceJdo.class})
@EnableConfigurationProperties(value={DatanucleusSettings.class})
public class CausewayModulePersistenceJdoDatanucleus {
    private static final Logger log = LogManager.getLogger(CausewayModulePersistenceJdoDatanucleus.class);
    public static final String NAMESPACE = "causeway.persistence.jdo";

    @Qualifier(value="jdo-dialect")
    @Bean
    public DnJdoDialect getDnJdoDialect(DataSource dataSource) {
        return new DnJdoDialect(dataSource);
    }

    @Qualifier(value="local-pmf-proxy")
    @Bean
    public LocalPersistenceManagerFactoryBean getLocalPersistenceManagerFactoryBean(CausewayConfiguration causewayConfiguration, final DataSource dataSource, final MetaModelContext metaModelContext, final ObjectLifecyclePublisher objectLifecyclePublisher, final CausewayBeanTypeRegistry beanTypeRegistry, DatanucleusSettings dnSettings) {
        _Assert.assertNotNull((Object)dataSource, (String)"a datasource is required");
        CausewayModulePersistenceJdoDatanucleus.autoCreateSchemas(dataSource, causewayConfiguration);
        LocalPersistenceManagerFactoryBean lpmfBean = new LocalPersistenceManagerFactoryBean(){

            protected PersistenceManagerFactory newPersistenceManagerFactory(Map<?, ?> props) {
                PersistenceUnitMetaData pu = CausewayModulePersistenceJdoDatanucleus.createDefaultPersistenceUnit(beanTypeRegistry);
                JDOPersistenceManagerFactory pmf = new JDOPersistenceManagerFactory(pu, props);
                pmf.setConnectionFactory((Object)dataSource);
                CausewayModulePersistenceJdoDatanucleus.integrateWithApplicationLayer(metaModelContext, objectLifecyclePublisher, (PersistenceManagerFactory)pmf);
                return pmf;
            }

            protected PersistenceManagerFactory newPersistenceManagerFactory(String name) {
                PersistenceManagerFactory pmf = super.newPersistenceManagerFactory(name);
                pmf.setConnectionFactory((Object)dataSource);
                CausewayModulePersistenceJdoDatanucleus.integrateWithApplicationLayer(metaModelContext, objectLifecyclePublisher, pmf);
                return pmf;
            }
        };
        lpmfBean.setJdoPropertyMap(dnSettings.getAsProperties());
        return lpmfBean;
    }

    @Qualifier(value="transaction-aware-pmf-proxy")
    @Bean
    @Primary
    public TransactionAwarePersistenceManagerFactoryProxy getTransactionAwarePersistenceManagerFactoryProxy(MetaModelContext metaModelContext, @Qualifier(value="local-pmf-proxy") LocalPersistenceManagerFactoryBean localPmfBean, CausewayBeanTypeRegistry beanTypeRegistry, List<JdoEntityDiscoveryListener> jdoEntityDiscoveryListeners, DatanucleusSettings dnSettings) {
        PersistenceManagerFactory pmf = localPmfBean.getObject();
        CausewayModulePersistenceJdoDatanucleus.notifyJdoEntityDiscoveryListeners(pmf, beanTypeRegistry, jdoEntityDiscoveryListeners, dnSettings);
        TransactionAwarePersistenceManagerFactoryProxy tapmfProxy = new TransactionAwarePersistenceManagerFactoryProxy();
        tapmfProxy.setTargetPersistenceManagerFactory(pmf);
        tapmfProxy.setAllowCreate(false);
        return tapmfProxy;
    }

    @Qualifier(value="jdo-platform-transaction-manager")
    @Bean
    @Primary
    public JdoTransactionManager getTransactionManager(@Qualifier(value="jdo-dialect") JdoDialect jdoDialect, @Qualifier(value="local-pmf-proxy") LocalPersistenceManagerFactoryBean localPmfBean) {
        PersistenceManagerFactory pmf = localPmfBean.getObject();
        JdoTransactionManager txManager = new JdoTransactionManager(pmf);
        txManager.setJdoDialect(jdoDialect);
        return txManager;
    }

    @Bean
    @Primary
    public TransactionInterceptorFactory getTransactionInterceptorFactory() {
        return () -> new TransactionInterceptor(){

            protected void completeTransactionAfterThrowing(TransactionAspectSupport.TransactionInfo txInfo, Throwable ex) {
                PlatformTransactionManager txManager;
                super.completeTransactionAfterThrowing(txInfo, ex);
                if (ex instanceof RuntimeException && (txManager = txInfo.getTransactionManager()) instanceof JdoTransactionManager) {
                    DataAccessException translatedEx;
                    JdoDialect jdoDialect = ((JdoTransactionManager)txManager).getJdoDialect();
                    if (jdoDialect instanceof PersistenceExceptionTranslator && (translatedEx = ((PersistenceExceptionTranslator)jdoDialect).translateExceptionIfPossible((RuntimeException)ex)) != null) {
                        throw translatedEx;
                    }
                    if (ex instanceof JDOException && (translatedEx = jdoDialect.translateException((JDOException)ex)) != null) {
                        throw translatedEx;
                    }
                }
            }
        };
    }

    private static void notifyJdoEntityDiscoveryListeners(PersistenceManagerFactory pmf, CausewayBeanTypeRegistry beanTypeRegistry, List<JdoEntityDiscoveryListener> jdoEntityDiscoveryListeners, DatanucleusSettings dnSettings) {
        if (_NullSafe.isEmpty(jdoEntityDiscoveryListeners)) {
            return;
        }
        Map jdoEntityTypes = beanTypeRegistry.getEntityTypes();
        if (_NullSafe.isEmpty((Map)jdoEntityTypes)) {
            return;
        }
        Set jdoEntityTypesView = Collections.unmodifiableSet(jdoEntityTypes.keySet());
        Map<String, Object> dnProps = Collections.unmodifiableMap(dnSettings.getAsProperties());
        jdoEntityDiscoveryListeners.forEach(listener -> listener.onEntitiesDiscovered(pmf, jdoEntityTypesView, dnProps));
    }

    private static DataSource autoCreateSchemas(DataSource dataSource, CausewayConfiguration causewayConfiguration) {
        CausewayConfiguration.Persistence.Schema persistenceSchemaConf = causewayConfiguration.getPersistence().getSchema();
        if (!persistenceSchemaConf.getAutoCreateSchemas().isEmpty()) {
            String createSchemaSqlTemplate = persistenceSchemaConf.getCreateSchemaSqlTemplate();
            log.info("About to create db schema(s) {} with template '{}'", (Object)persistenceSchemaConf.getAutoCreateSchemas(), (Object)createSchemaSqlTemplate);
            try (Connection con = dataSource.getConnection();){
                Statement s = con.createStatement();
                for (String schema : persistenceSchemaConf.getAutoCreateSchemas()) {
                    String sql = String.format(createSchemaSqlTemplate, schema, schema, schema, schema, schema, schema, schema);
                    log.info("SQL '{}'", (Object)sql);
                    s.execute(sql);
                }
            }
        }
        return dataSource;
    }

    private static PersistenceUnitMetaData createDefaultPersistenceUnit(CausewayBeanTypeRegistry beanTypeRegistry) {
        PersistenceUnitMetaData pumd = new PersistenceUnitMetaData("dynamic-unit", "RESOURCE_LOCAL", null);
        pumd.setExcludeUnlistedClasses(false);
        beanTypeRegistry.getEntityTypes().keySet().stream().map(Class::getName).forEach(arg_0 -> ((PersistenceUnitMetaData)pumd).addClassName(arg_0));
        return pumd;
    }

    private static void integrateWithApplicationLayer(MetaModelContext metaModelContext, ObjectLifecyclePublisher objectLifecyclePublisher, PersistenceManagerFactory pmf) {
        JdoLifecycleListener jdoLifecycleListener = new JdoLifecycleListener(metaModelContext, objectLifecyclePublisher);
        pmf.addInstanceLifecycleListener((InstanceLifecycleListener)jdoLifecycleListener, (Class[])null);
    }
}

