/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.changetracking;

import javax.jdo.JDOHelper;
import javax.jdo.ObjectState;
import javax.jdo.listener.InstanceLifecycleEvent;
import lombok.NonNull;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnStateManagerForCauseway;
import org.datanucleus.enhancement.Persistable;

final class _Utils {
    static Persistable persistableFor(InstanceLifecycleEvent event) {
        return (Persistable)event.getPersistentInstance();
    }

    static void resolveInjectionPoints(@NonNull MetaModelContext mmc, @NonNull InstanceLifecycleEvent event) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        Persistable pojo = _Utils.persistableFor(event);
        if (pojo != null) {
            DnStateManagerForCauseway.extractFrom(pojo).ifPresentOrElse(DnStateManagerForCauseway::injectServicesIfNotAlready, () -> mmc.getServiceInjector().injectServicesInto((Object)pojo));
        }
    }

    static ManagedObject adaptEntity(@NonNull MetaModelContext mmc, @NonNull Object entityPojo) {
        if (mmc == null) {
            throw new NullPointerException("mmc is marked non-null but is null");
        }
        if (entityPojo == null) {
            throw new NullPointerException("entityPojo is marked non-null but is null");
        }
        ObjectManager objectManager = mmc.getObjectManager();
        ManagedObject entity = objectManager.adapt(entityPojo);
        _Assert.assertTrue((boolean)entity.getSpecification().isEntity());
        return entity;
    }

    static String debug(InstanceLifecycleEvent event) {
        Persistable pojo = _Utils.persistableFor(event);
        ObjectState state = JDOHelper.getObjectState((Object)pojo);
        return String.format("entity: %s (%s)", pojo.getClass().getSimpleName(), state);
    }

    private _Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

