/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.prop.column;

import java.util.Optional;
import javax.inject.Inject;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FacetUtil;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.core.metamodel.facets.FacetedMethod;
import org.apache.causeway.core.metamodel.progmodel.ProgrammingModel;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.persistence.commons.metamodel.facets.prop.column.MaxLengthFromXxxColumnAnnotationMetaModelRefinerUtil;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MaxLengthFacetFromJdoColumnAnnotation;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class MaxLengthFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelRefiner {
    @Inject
    private JdoFacetContext jdoFacetContext;

    public MaxLengthFromJdoColumnAnnotationFacetFactory(MetaModelContext mmc) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        if (String.class != processMethodContext.getMethod().getReturnType()) {
            return;
        }
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        Optional jdoColumnIfAny = processMethodContext.synthesizeOnMethod(Column.class);
        FacetUtil.addFacetIfPresent(MaxLengthFacetFromJdoColumnAnnotation.create(jdoColumnIfAny, (FacetHolder)facetHolder));
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel) {
        programmingModel.addValidatorSkipManagedBeans(objectSpec -> {
            JdoPersistenceCapableFacet pcFacet = (JdoPersistenceCapableFacet)objectSpec.getFacet(JdoPersistenceCapableFacet.class);
            if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                return;
            }
            objectSpec.streamProperties(MixedIn.EXCLUDED).filter(association -> !association.containsNonFallbackFacet(JdoNotPersistentFacet.class)).forEach(MaxLengthFromXxxColumnAnnotationMetaModelRefinerUtil::validateMaxLengthFacet);
        }, new ProgrammingModel.Marker[0]);
    }
}

