/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.spring.integration;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import lombok.NonNull;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.persistence.jdo.spring.integration.PersistenceManagerFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TransactionAwarePersistenceManagerFactoryProxy
implements FactoryBean<PersistenceManagerFactory>,
HasMetaModelContext {
    private PersistenceManagerFactory target;
    private boolean allowCreate = true;
    private PersistenceManagerFactory proxy;

    public void setTargetPersistenceManagerFactory(PersistenceManagerFactory target) {
        Assert.notNull((Object)target, (String)"Target PersistenceManagerFactory must not be null");
        this.target = target;
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(target.getClass(), (ClassLoader)target.getClass().getClassLoader());
        this.proxy = (PersistenceManagerFactory)Proxy.newProxyInstance(target.getClass().getClassLoader(), ifcs, (InvocationHandler)new PersistenceManagerFactoryInvocationHandler());
    }

    public PersistenceManagerFactory getTargetPersistenceManagerFactory() {
        return this.target;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    protected boolean isAllowCreate() {
        return this.allowCreate;
    }

    public PersistenceManagerFactory getObject() {
        return this.proxy;
    }

    public Class<? extends PersistenceManagerFactory> getObjectType() {
        return PersistenceManagerFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.getObject();
    }

    private class PersistenceManagerFactoryInvocationHandler
    implements InvocationHandler {
        private PersistenceManagerFactoryInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("getPersistenceManager")) {
                PersistenceManagerFactory pmf = TransactionAwarePersistenceManagerFactoryProxy.this.getTargetPersistenceManagerFactory();
                PersistenceManager pm = PersistenceManagerFactoryUtils.doGetPersistenceManager(pmf, TransactionAwarePersistenceManagerFactoryProxy.this.isAllowCreate());
                Class[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), (ClassLoader)pm.getClass().getClassLoader());
                return Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new PersistenceManagerInvocationHandler(pm, pmf));
            }
            try {
                return method.invoke((Object)TransactionAwarePersistenceManagerFactoryProxy.this.getTargetPersistenceManagerFactory(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class PersistenceManagerInvocationHandler
    implements InvocationHandler {
        private final PersistenceManager pm;
        private final PersistenceManagerFactory persistenceManagerFactory;

        public PersistenceManagerInvocationHandler(@NonNull PersistenceManager pm, @NonNull PersistenceManagerFactory pmf) {
            if (pm == null) {
                throw new NullPointerException("pm is marked non-null but is null");
            }
            if (pmf == null) {
                throw new NullPointerException("pmf is marked non-null but is null");
            }
            this.pm = pm;
            this.persistenceManagerFactory = pmf;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                PersistenceManagerFactoryUtils.doReleasePersistenceManager(this.pm, this.persistenceManagerFactory);
                return null;
            }
            try {
                return method.invoke((Object)this.pm, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

