/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.h2console.ui.services;

import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.apache.causeway.applib.CausewayModuleApplib;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.value.LocalResourcePath;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.testing.h2console.ui.webmodule.WebModuleH2Console;

@DomainService
@Named(value="causeway.ext.h2Console.H2ManagerMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class H2ManagerMenu {
    private final WebModuleH2Console webModule;
    private final CausewayConfiguration causewayConfiguration;

    @Action(semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING, domainEvent=ActionDomainEvent.class)
    @ActionLayout(named="H2 Console", cssClassFa="database", sequence="500.800")
    public LocalResourcePath openH2Console() {
        return this.getPathToH2Console().orElse(null);
    }

    @MemberSupport
    public boolean hideOpenH2Console() {
        return this.getPathToH2Console().isEmpty();
    }

    private Optional<LocalResourcePath> getPathToH2Console() {
        return Optional.ofNullable(this.webModule).map(WebModuleH2Console::getLocalResourcePathIfEnabled);
    }

    @Inject
    @Generated
    public H2ManagerMenu(WebModuleH2Console webModule, CausewayConfiguration causewayConfiguration) {
        this.webModule = webModule;
        this.causewayConfiguration = causewayConfiguration;
    }

    public static class ActionDomainEvent
    extends CausewayModuleApplib.ActionDomainEvent<H2ManagerMenu> {
    }
}

