/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.h2console.ui.webmodule;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebServlet;

public interface H2WebServerWrapper {
    public void setConnectionInfo(ConnectionInfo var1);

    public void setAllowOthers(boolean var1);

    public boolean getAllowOthers();

    public void setAdminPassword(String var1);

    public static void withH2WebServerWrapperDo(@NonNull WebServlet webServlet, @NonNull Consumer<H2WebServerWrapper> onConfiguration) {
        if (webServlet == null) {
            throw new NullPointerException("webServlet is marked non-null but is null");
        }
        if (onConfiguration == null) {
            throw new NullPointerException("onConfiguration is marked non-null but is null");
        }
        try {
            H2WebServerWrapper serverWrapper = H2WebServerWrapper.wrap(webServlet);
            onConfiguration.accept(serverWrapper);
        }
        catch (Throwable cause) {
            throw _Exceptions.unrecoverable((Throwable)cause, (String)"Unable to customize settings for H2 console");
        }
    }

    private static H2WebServerWrapper wrap(final @NonNull WebServlet webServlet) {
        if (webServlet == null) {
            throw new NullPointerException("webServlet is marked non-null but is null");
        }
        return new H2WebServerWrapper(){
            final WebServer webServer;
            {
                this.webServer = (WebServer)_Reflect.getFieldOn((Field)WebServlet.class.getDeclaredField("server"), (Object)webServlet);
            }

            @Override
            public void setConnectionInfo(ConnectionInfo connectionInfo) {
                Method updateSettingMethod = WebServer.class.getDeclaredMethod("updateSetting", ConnectionInfo.class);
                _Reflect.invokeMethodOn((Method)updateSettingMethod, (Object)this.webServer, (Object[])new Object[]{connectionInfo});
            }

            @Override
            public void setAllowOthers(boolean b) {
                Method method = WebServer.class.getDeclaredMethod("setAllowOthers", Boolean.TYPE);
                _Reflect.invokeMethodOn((Method)method, (Object)this.webServer, (Object[])new Object[]{b});
                _Assert.assertEquals((Object)b, (Object)this.getAllowOthers());
            }

            @Override
            public boolean getAllowOthers() {
                Method method = WebServer.class.getDeclaredMethod("getAllowOthers", _Constants.emptyClasses);
                return (Boolean)_Reflect.invokeMethodOn((Method)method, (Object)this.webServer, (Object[])_Constants.emptyObjects).getValue().get();
            }

            @Override
            public void setAdminPassword(String password) {
                Method method = WebServer.class.getDeclaredMethod("setAdminPassword", String.class);
                _Reflect.invokeMethodOn((Method)method, (Object)this.webServer, (Object[])new Object[]{password});
            }
        };
    }
}

