/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.h2console.ui.webmodule;

import java.util.function.Consumer;
import lombok.NonNull;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.H2WebServletForJakarta;
import org.h2.server.web.WebServer;

public interface H2WebServerWrapper {
    public void setConnectionInfo(ConnectionInfo var1);

    public void setAllowOthers(boolean var1);

    public boolean getAllowOthers();

    public void setAdminPassword(String var1);

    public static void withH2WebServerWrapperDo(final @NonNull H2WebServletForJakarta webServlet, @NonNull Consumer<H2WebServerWrapper> onConfiguration) {
        if (webServlet == null) {
            throw new NullPointerException("webServlet is marked non-null but is null");
        }
        if (onConfiguration == null) {
            throw new NullPointerException("onConfiguration is marked non-null but is null");
        }
        onConfiguration.accept(new H2WebServerWrapper(){

            @Override
            public void setConnectionInfo(ConnectionInfo connectionInfo) {
                webServlet.setConnectionInfo(connectionInfo);
            }

            @Override
            public void setAllowOthers(boolean b) {
                webServlet.setAllowOthers(b);
            }

            @Override
            public boolean getAllowOthers() {
                return webServlet.getAllowOthers();
            }

            @Override
            public void setAdminPassword(String password) {
                String encodedPassword = WebServer.encodeAdminPassword((String)password);
                webServlet.setAdminPassword(encodedPassword);
            }
        });
    }
}

