/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.applib.services.menu.model;

import java.util.List;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuAction;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuDropdown;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuEntry;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuSpacer;

public record MenuDropdownBuilder(@NonNull String name, @NonNull List<MenuEntry> subEntries) {
    public MenuDropdownBuilder(@NonNull String name, @NonNull List<MenuEntry> subEntries) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (subEntries == null) {
            throw new NullPointerException("subEntries is marked non-null but is null");
        }
    }

    public void addSectionSpacer() {
        this.subEntries().add(MenuSpacer.empty());
    }

    public void addSectionSpacer(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.subEntries().add(new MenuSpacer(label));
    }

    public void addAction(ManagedAction action) {
        this.subEntries().add(MenuAction.of(action));
    }

    public MenuDropdown build() {
        return new MenuDropdown(this.name, (Can<MenuEntry>)Can.ofCollection(this.subEntries));
    }
}

