/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.decorators;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.core.config.messages.MessageRegistry;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;

@FunctionalInterface
public interface ConfirmDecorator<T> {
    public void decorate(T var1, ConfirmDecorationModel var2);

    public static class ConfirmDecorationModel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        final String title;
        @NonNull
        final Optional<String> message;
        @NonNull
        final String okLabel;
        @NonNull
        final String cancelLabel;
        @NonNull
        final UiPlacementDirection placement;

        public static ConfirmDecorationModel areYouSure(TranslationService translationService, UiPlacementDirection placement) {
            TranslationContext context = TranslationContext.forClassName(MessageRegistry.class);
            String areYouSure = ConfirmDecorationModel.translate(translationService, context, "Are you sure?");
            String confirm = ConfirmDecorationModel.translate(translationService, context, "Confirm");
            String cancel = ConfirmDecorationModel.translate(translationService, context, "Cancel");
            Optional<String> message = Optional.empty();
            return ConfirmDecorationModel.of(areYouSure, message, confirm, cancel, placement);
        }

        private static String translate(TranslationService translationService, TranslationContext context, String msg) {
            if (translationService != null) {
                return translationService.translate(context, msg);
            }
            return msg;
        }

        @NonNull
        @Generated
        public String getTitle() {
            return this.title;
        }

        @NonNull
        @Generated
        public Optional<String> getMessage() {
            return this.message;
        }

        @NonNull
        @Generated
        public String getOkLabel() {
            return this.okLabel;
        }

        @NonNull
        @Generated
        public String getCancelLabel() {
            return this.cancelLabel;
        }

        @NonNull
        @Generated
        public UiPlacementDirection getPlacement() {
            return this.placement;
        }

        @Generated
        private ConfirmDecorationModel(@NonNull String title, @NonNull Optional<String> message, @NonNull String okLabel, @NonNull String cancelLabel, @NonNull UiPlacementDirection placement) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (okLabel == null) {
                throw new NullPointerException("okLabel is marked non-null but is null");
            }
            if (cancelLabel == null) {
                throw new NullPointerException("cancelLabel is marked non-null but is null");
            }
            if (placement == null) {
                throw new NullPointerException("placement is marked non-null but is null");
            }
            this.title = title;
            this.message = message;
            this.okLabel = okLabel;
            this.cancelLabel = cancelLabel;
            this.placement = placement;
        }

        @Generated
        private static ConfirmDecorationModel of(@NonNull String title, @NonNull Optional<String> message, @NonNull String okLabel, @NonNull String cancelLabel, @NonNull UiPlacementDirection placement) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (okLabel == null) {
                throw new NullPointerException("okLabel is marked non-null but is null");
            }
            if (cancelLabel == null) {
                throw new NullPointerException("cancelLabel is marked non-null but is null");
            }
            if (placement == null) {
                throw new NullPointerException("placement is marked non-null but is null");
            }
            return new ConfirmDecorationModel(title, message, okLabel, cancelLabel, placement);
        }
    }
}

