/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.decorators;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.springframework.lang.Nullable;

@FunctionalInterface
public interface TooltipDecorator<T> {
    public void decorate(T var1, TooltipDecorationModel var2);

    public static final class TooltipDecorationModel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final UiPlacementDirection placementDirection;
        @NonNull
        private final Optional<String> title;
        @NonNull
        private final String body;

        public static TooltipDecorationModel ofBody(@NonNull UiPlacementDirection uiPlacementDirection, @Nullable String body) {
            if (uiPlacementDirection == null) {
                throw new NullPointerException("uiPlacementDirection is marked non-null but is null");
            }
            return TooltipDecorationModel.of(uiPlacementDirection, Optional.empty(), _Strings.nonEmpty((CharSequence)body).orElse(""));
        }

        public static TooltipDecorationModel ofTitleAndBody(@NonNull UiPlacementDirection uiPlacementDirection, @Nullable String title, @Nullable String body) {
            if (uiPlacementDirection == null) {
                throw new NullPointerException("uiPlacementDirection is marked non-null but is null");
            }
            return TooltipDecorationModel.of(uiPlacementDirection, _Strings.nonEmpty((CharSequence)title), _Strings.nonEmpty((CharSequence)body).orElse(""));
        }

        public static TooltipDecorationModel empty() {
            return TooltipDecorationModel.ofBody(UiPlacementDirection.BOTTOM, "");
        }

        public boolean isEmpty() {
            return this.body.isEmpty();
        }

        @Generated
        private TooltipDecorationModel(@NonNull UiPlacementDirection placementDirection, @NonNull Optional<String> title, @NonNull String body) {
            if (placementDirection == null) {
                throw new NullPointerException("placementDirection is marked non-null but is null");
            }
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (body == null) {
                throw new NullPointerException("body is marked non-null but is null");
            }
            this.placementDirection = placementDirection;
            this.title = title;
            this.body = body;
        }

        @Generated
        public static TooltipDecorationModel of(@NonNull UiPlacementDirection placementDirection, @NonNull Optional<String> title, @NonNull String body) {
            if (placementDirection == null) {
                throw new NullPointerException("placementDirection is marked non-null but is null");
            }
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (body == null) {
                throw new NullPointerException("body is marked non-null but is null");
            }
            return new TooltipDecorationModel(placementDirection, title, body);
        }

        @NonNull
        @Generated
        public UiPlacementDirection getPlacementDirection() {
            return this.placementDirection;
        }

        @NonNull
        @Generated
        public Optional<String> getTitle() {
            return this.title;
        }

        @NonNull
        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TooltipDecorationModel)) {
                return false;
            }
            TooltipDecorationModel other = (TooltipDecorationModel)o;
            UiPlacementDirection this$placementDirection = this.getPlacementDirection();
            UiPlacementDirection other$placementDirection = other.getPlacementDirection();
            if (this$placementDirection == null ? other$placementDirection != null : !((Object)((Object)this$placementDirection)).equals((Object)other$placementDirection)) {
                return false;
            }
            Optional<String> this$title = this.getTitle();
            Optional<String> other$title = other.getTitle();
            if (this$title == null ? other$title != null : !((Object)this$title).equals(other$title)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UiPlacementDirection $placementDirection = this.getPlacementDirection();
            result = result * 59 + ($placementDirection == null ? 43 : ((Object)((Object)$placementDirection)).hashCode());
            Optional<String> $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : ((Object)$title).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TooltipDecorator.TooltipDecorationModel(placementDirection=" + this.getPlacementDirection() + ", title=" + this.getTitle() + ", body=" + this.getBody() + ")";
        }
    }
}

