/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.layout;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.layout.component.ActionLayoutData;
import org.apache.causeway.applib.layout.component.CollectionLayoutData;
import org.apache.causeway.applib.layout.component.DomainObjectLayoutData;
import org.apache.causeway.applib.layout.component.FieldSet;
import org.apache.causeway.applib.layout.component.PropertyLayoutData;
import org.apache.causeway.applib.layout.grid.bootstrap.BSClearFix;
import org.apache.causeway.applib.layout.grid.bootstrap.BSCol;
import org.apache.causeway.applib.layout.grid.bootstrap.BSGrid;
import org.apache.causeway.applib.layout.grid.bootstrap.BSRow;
import org.apache.causeway.applib.layout.grid.bootstrap.BSRowContent;
import org.apache.causeway.applib.layout.grid.bootstrap.BSTab;
import org.apache.causeway.applib.layout.grid.bootstrap.BSTabGroup;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.UiModel;

public class UiGridLayout
implements UiModel {
    @NonNull
    private final ManagedObject managedObject;
    private _Lazy<Optional<BSGrid>> gridData = _Lazy.threadSafe(this::initGridData);

    public <C, T> void visit(Visitor<C, T> visitor) {
        ((Optional)this.gridData.get()).ifPresent(bsGrid -> {
            for (BSRow bsRow : bsGrid.getRows()) {
                this.visitRow(bsRow, visitor.rootContainer, visitor);
            }
        });
    }

    private Optional<BSGrid> initGridData() {
        return Facets.bootstrapGrid((ObjectSpecification)this.managedObject.getSpecification(), (ManagedObject)this.managedObject).map(this::attachAssociatedActions);
    }

    private BSGrid attachAssociatedActions(BSGrid bSGrid) {
        LinkedHashMap primedActions = bSGrid.getAllActionsById();
        HashSet actionIdsAlreadyAdded = _Sets.newHashSet(primedActions.keySet());
        this.managedObject.getSpecification().streamProperties(MixedIn.INCLUDED).forEach(property -> Optional.ofNullable((PropertyLayoutData)bSGrid.getAllPropertiesById().get(property.getId())).ifPresent(pl -> ObjectAction.Util.findForAssociation((ManagedObject)this.managedObject, (ObjectAssociation)property).map(action -> action.getId()).filter(id -> !actionIdsAlreadyAdded.contains(id)).peek(actionIdsAlreadyAdded::add).map(ActionLayoutData::new).forEach(pl.getActions()::add)));
        return bSGrid;
    }

    private <C, T> void visitRow(BSRow bsRow, C container, Visitor<C, T> visitor) {
        C uiRow = visitor.newRow(container, bsRow);
        for (BSRowContent bsRowContent : bsRow.getCols()) {
            if (bsRowContent instanceof BSCol) {
                this.visitCol((BSCol)bsRowContent, uiRow, visitor);
                continue;
            }
            if (bsRowContent instanceof BSClearFix) {
                visitor.onClearfix(uiRow, (BSClearFix)bsRowContent);
                continue;
            }
            throw new IllegalStateException("Unrecognized implementation of BSRowContent");
        }
    }

    private <C, T> void visitCol(BSCol bSCol, C container, Visitor<C, T> visitor) {
        boolean hasRows;
        C uiCol = visitor.newCol(container, bSCol);
        boolean hasDomainObject = bSCol.getDomainObject() != null;
        boolean hasActions = _NullSafe.size((Collection)bSCol.getActions()) > 0;
        boolean bl = hasRows = _NullSafe.size((Collection)bSCol.getRows()) > 0;
        if (hasDomainObject || hasActions) {
            C uiActionPanel = visitor.newActionPanel(uiCol);
            if (hasDomainObject) {
                visitor.onObjectTitle(uiActionPanel, bSCol.getDomainObject());
            }
            if (hasActions) {
                for (ActionLayoutData action : bSCol.getActions()) {
                    visitor.onAction(uiActionPanel, action);
                }
            }
        }
        for (FieldSet fieldSet : bSCol.getFieldSets()) {
            this.visitFieldSet(fieldSet, uiCol, visitor);
        }
        for (BSTabGroup tabGroup : bSCol.getTabGroups()) {
            this.visitTabGroup(tabGroup, uiCol, visitor);
        }
        if (hasRows) {
            for (BSRow bsRow : bSCol.getRows()) {
                this.visitRow(bsRow, uiCol, visitor);
            }
        }
        for (CollectionLayoutData collectionData : bSCol.getCollections()) {
            visitor.onCollection(uiCol, collectionData);
        }
    }

    private <C, T> void visitTabGroup(BSTabGroup BSColTabGroup, C container, Visitor<C, T> visitor) {
        T uiTabGroup = visitor.newTabGroup(container, BSColTabGroup);
        for (BSTab bsTab : BSColTabGroup.getTabs()) {
            this.visitTab(bsTab, uiTabGroup, visitor);
        }
    }

    private <C, T> void visitTab(BSTab bSTab, T container, Visitor<C, T> visitor) {
        C uiTab = visitor.newTab(container, bSTab);
        for (BSRow bsRow : bSTab.getRows()) {
            this.visitRow(bsRow, uiTab, visitor);
        }
    }

    private <C, T> void visitFieldSet(FieldSet cptFieldSet, C container, Visitor<C, T> visitor) {
        C uiFieldSet = visitor.newFieldSet(container, cptFieldSet);
        for (PropertyLayoutData propertyData : cptFieldSet.getProperties()) {
            visitor.onProperty(uiFieldSet, propertyData);
        }
    }

    @Generated
    private UiGridLayout(@NonNull ManagedObject managedObject) {
        if (managedObject == null) {
            throw new NullPointerException("managedObject is marked non-null but is null");
        }
        this.managedObject = managedObject;
    }

    @Generated
    public static UiGridLayout bind(@NonNull ManagedObject managedObject) {
        if (managedObject == null) {
            throw new NullPointerException("managedObject is marked non-null but is null");
        }
        return new UiGridLayout(managedObject);
    }

    public static abstract class Visitor<C, T> {
        private final C rootContainer;

        protected abstract C newActionPanel(C var1);

        protected abstract C newRow(C var1, BSRow var2);

        protected abstract C newCol(C var1, BSCol var2);

        protected abstract T newTabGroup(C var1, BSTabGroup var2);

        protected abstract C newTab(T var1, BSTab var2);

        protected abstract C newFieldSet(C var1, FieldSet var2);

        protected abstract void onObjectTitle(C var1, DomainObjectLayoutData var2);

        protected abstract void onClearfix(C var1, BSClearFix var2);

        protected abstract void onAction(C var1, ActionLayoutData var2);

        protected abstract void onProperty(C var1, PropertyLayoutData var2);

        protected abstract void onCollection(C var1, CollectionLayoutData var2);

        @Generated
        public Visitor(C rootContainer) {
            this.rootContainer = rootContainer;
        }
    }
}

