/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.decorators;

import java.util.Optional;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.commons.model.layout.UiPlacementDirection;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface TooltipDecorator<T> {
    public void decorate(T var1, TooltipDecorationModel var2);

    public record TooltipDecorationModel(@NonNull UiPlacementDirection placementDirection, @NonNull Optional<String> title, @NonNull String body) {
        public static TooltipDecorationModel ofBody(@NonNull UiPlacementDirection uiPlacementDirection, @Nullable String body) {
            return new TooltipDecorationModel(uiPlacementDirection, Optional.empty(), _Strings.nonEmpty((CharSequence)body).orElse(""));
        }

        public static TooltipDecorationModel ofTitleAndBody(@NonNull UiPlacementDirection uiPlacementDirection, @Nullable String title, @Nullable String body) {
            return new TooltipDecorationModel(uiPlacementDirection, _Strings.nonEmpty((CharSequence)title), _Strings.nonEmpty((CharSequence)body).orElse(""));
        }

        public static TooltipDecorationModel empty() {
            return TooltipDecorationModel.ofBody(UiPlacementDirection.BOTTOM, "");
        }

        public boolean isEmpty() {
            return this.body.isEmpty();
        }
    }
}

