/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.services.i8n;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import lombok.Generated;
import org.apache.causeway.applib.services.i18n.TranslationsResolver;
import org.apache.causeway.commons.io.TextUtils;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.commons.TranslationsResolverDefault")
@Priority(value=0x3FFFFFFF)
public class TranslationsResolverDefault
implements TranslationsResolver {
    @Generated
    private static final Logger log = LogManager.getLogger(TranslationsResolverDefault.class);
    private final ServletContext servletContext;
    private final CausewayConfiguration causewayConfiguration;
    private static final Pattern nonEmpty = Pattern.compile("^(#:|msgid|msgstr).+$");

    public List<String> readLines(String fileName) {
        String configLocation = this.causewayConfiguration.getCore().getRuntimeServices().getTranslation().getResourceLocation();
        try {
            if (configLocation != null) {
                log.info("Reading translations relative to config override location: {}", (Object)configLocation);
                return Files.readAllLines(TranslationsResolverDefault.newFile(configLocation, fileName), StandardCharsets.UTF_8);
            }
            URL url = this.servletContext.getResource("/WEB-INF/" + fileName);
            return TranslationsResolverDefault.readLines(url);
        }
        catch (IOException | RuntimeException ignored) {
            return Collections.emptyList();
        }
    }

    static Path newFile(String dir, String fileName) {
        File base = new File(dir);
        Path path = base.toPath();
        return path.resolve(fileName);
    }

    private static List<String> readLines(URL url) throws IOException {
        if (url == null) {
            return Collections.emptyList();
        }
        List acceptedLines = TextUtils.readLinesFromUrl((URL)url, (Charset)StandardCharsets.UTF_8).stream().filter(input -> input != null && nonEmpty.matcher((CharSequence)input).matches()).collect(Collectors.toList());
        return Collections.unmodifiableList(acceptedLines);
    }

    @Inject
    @Generated
    public TranslationsResolverDefault(ServletContext servletContext, CausewayConfiguration causewayConfiguration) {
        this.servletContext = servletContext;
        this.causewayConfiguration = causewayConfiguration;
    }
}

