/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.services.menu;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.id.HasLogicalType;
import org.apache.causeway.applib.layout.menubars.MenuBars;
import org.apache.causeway.applib.layout.menubars.bootstrap.BSMenuBar;
import org.apache.causeway.applib.services.menu.MenuBarsService;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuUiModel;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuUiService;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuVisitor;
import org.apache.causeway.viewer.commons.services.menu._MenuItemBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.commons.MenuUiServiceDefault")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="Default")
public class MenuUiServiceDefault
implements MenuUiService {
    private final MetaModelContext metaModelContext;
    private final MenuBarsService menuBarsService;

    public MenuUiModel getMenu(DomainServiceLayout.MenuBar menuBarSelect) {
        return MenuUiModel.of((DomainServiceLayout.MenuBar)menuBarSelect, this.select(menuBarSelect));
    }

    public void buildMenuItems(MenuUiModel menuUiModel, MenuVisitor menuBuilder) {
        MenuBars menuBars = this.menuBarsService.menuBars();
        BSMenuBar menuBar = (BSMenuBar)menuBars.menuBarFor(menuUiModel.getMenuBarSelect());
        _MenuItemBuilder.buildMenuItems(this.metaModelContext, menuBar, menuBuilder);
    }

    private List<String> select(DomainServiceLayout.MenuBar menuBarSelect) {
        return this.metaModelContext.streamServiceAdapters().filter(MenuUiServiceDefault.with(menuBarSelect)).map(ManagedObject::getSpecification).map(HasLogicalType::getLogicalTypeName).collect(Collectors.toList());
    }

    private static Predicate<ManagedObject> with(DomainServiceLayout.MenuBar menuBarSelect) {
        return adapter -> Facets.domainServiceLayoutMenuBar((ObjectSpecification)adapter.getSpecification()).orElse(DomainServiceLayout.MenuBar.PRIMARY).equals((Object)menuBarSelect);
    }

    @Inject
    @Generated
    public MenuUiServiceDefault(MetaModelContext metaModelContext, MenuBarsService menuBarsService) {
        this.metaModelContext = metaModelContext;
        this.menuBarsService = menuBarsService;
    }
}

