/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.services.userprof;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.commons.applib.services.userprof.UserProfileUiModel;
import org.apache.causeway.viewer.commons.applib.services.userprof.UserProfileUiService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.commons.UserProfileUiServiceDefault")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="Default")
public class UserProfileUiServiceDefault
implements UserProfileUiService {
    private final UserService userService;
    private final TranslationService translationService;

    public UserProfileUiModel userProfile() {
        return UserProfileUiModel.of((String)this.userProfileName(), (UserMemento)this.userService.currentUser().orElse(null));
    }

    private String userProfileName() {
        return this.userService.currentUser().map(this::userNameFor).orElse(String.format("<%s>", this.translated("Anonymous")));
    }

    private String userNameFor(UserMemento user) {
        if (user.isImpersonating()) {
            return user.nameFormatted();
        }
        String realName = user.getRealName();
        return _Strings.isNullOrEmpty((CharSequence)realName) ? user.getName() : realName;
    }

    private String translated(String str) {
        return this.translationService.translate(TranslationContext.forClassName(this.getClass()), str);
    }

    @Inject
    public UserProfileUiServiceDefault(UserService userService, TranslationService translationService) {
        this.userService = userService;
        this.translationService = translationService;
    }
}

