/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.scenario;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.causeway.applib.services.metamodel.BeanSort;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.Parent;
import org.apache.causeway.viewer.graphql.model.domain.common.SchemaStrategy;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainObject;
import org.apache.causeway.viewer.graphql.model.domain.common.query.CommonDomainService;

public class ScenarioStep
extends ElementCustom
implements Parent {
    private final List<CommonDomainService> domainServices = new ArrayList<CommonDomainService>();
    private final List<CommonDomainObject> domainObjects = new ArrayList<CommonDomainObject>();

    public ScenarioStep(SchemaStrategy schemaStrategy, Context context) {
        super("ScenarioStep", context);
        if (this.isBuilt()) {
            return;
        }
        context.objectSpecifications().forEach(objectSpec -> {
            switch (objectSpec.getBeanSort()) {
                case ABSTRACT: 
                case VIEW_MODEL: 
                case ENTITY: {
                    CommonDomainObject gqlvDomainObject = schemaStrategy.domainObjectFor((ObjectSpecification)objectSpec, context);
                    this.addChildField(gqlvDomainObject.newField());
                    this.domainObjects.add(gqlvDomainObject);
                }
            }
        });
        context.objectSpecifications().forEach(objectSpec -> {
            if (Objects.requireNonNull(objectSpec.getBeanSort()) == BeanSort.MANAGED_BEAN_CONTRIBUTING) {
                context.serviceRegistry.lookupBeanById(objectSpec.getLogicalTypeName()).ifPresent(servicePojo -> this.domainServices.add(this.addChildFieldFor(schemaStrategy.domainServiceFor((ObjectSpecification)objectSpec, servicePojo, context))));
            }
        });
        this.buildObjectType();
    }

    @Override
    protected void addDataFetchersForChildren() {
        this.domainServices.forEach(domainService -> {
            boolean actionsAdded = domainService.hasActions();
            if (actionsAdded) {
                domainService.addDataFetcher(this);
            }
        });
        this.domainObjects.forEach(domainObject -> domainObject.addDataFetcher(this));
    }

    protected DataFetchingEnvironment fetchData(DataFetchingEnvironment environment) {
        return environment;
    }
}

