/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.common.query;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.List;
import org.apache.causeway.core.metamodel.spec.ActionScope;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.SchemaStrategy;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.query.ObjectFeatureUtils;
import org.apache.causeway.viewer.graphql.model.mmproviders.ObjectSpecificationProvider;
import org.apache.causeway.viewer.graphql.model.mmproviders.SchemaTypeProvider;

public class CommonDomainObject
extends ElementCustom
implements ObjectInteractor,
ObjectSpecificationProvider,
SchemaTypeProvider {
    private final SchemaStrategy schemaStrategy;
    private final ObjectSpecification objectSpecification;
    private final ElementCustom meta;
    private final List<Element> properties = new ArrayList<Element>();
    private final List<Element> collections = new ArrayList<Element>();
    private final List<Element> actions = new ArrayList<Element>();
    private final GraphQLInputObjectType gqlInputObjectType;

    @Override
    public SchemaType getSchemaType() {
        return this.schemaStrategy.getSchemaType();
    }

    public static String typeNameFor(SchemaStrategy schemaStrategy, ObjectSpecification objectSpecification) {
        return TypeNames.objectTypeNameFor(objectSpecification, schemaStrategy.getSchemaType());
    }

    public CommonDomainObject(SchemaStrategy schemaStrategy, String typeName, ObjectSpecification objectSpecification, Context context) {
        super(typeName, context);
        this.schemaStrategy = schemaStrategy;
        this.objectSpecification = objectSpecification;
        this.gqlObjectTypeBuilder.description(objectSpecification.getDescription());
        this.meta = schemaStrategy.newMeta(this, context);
        this.addChildFieldFor(this.meta);
        GraphQLInputObjectType.Builder inputObjectTypeBuilder = GraphQLInputObjectType.newInputObject().name(TypeNames.inputTypeNameFor(objectSpecification, this.getSchemaType()));
        inputObjectTypeBuilder.field(GraphQLInputObjectField.newInputObjectField().name("id").description("Use either 'id' or 'ref'; looks up an entity from the persistent data store, or if a view model, then recreates using the id as a memento of the object's state").type((GraphQLInputType)Scalars.GraphQLID).build()).field(GraphQLInputObjectField.newInputObjectField().name("logicalTypeName").description("If object identified by 'id', then optionally specifies concrete type.  This is only required if the parameter type defines a super class").type((GraphQLInputType)context.getLogicalTypeNames()).build()).field(GraphQLInputObjectField.newInputObjectField().name("ref").description("Use either 'ref' or 'id'; looks up an object previously saved to the execution context using 'saveAs(ref: ...)'").type((GraphQLInputType)Scalars.GraphQLString).build());
        this.gqlInputObjectType = inputObjectTypeBuilder.build();
        this.setField(this.newField());
        this.addMembers();
        GraphQLObjectType objectType = this.buildObjectType();
        context.graphQLTypeRegistry.addTypeIfNotAlreadyPresent((GraphQLType)objectType);
        context.graphQLTypeRegistry.addTypeIfNotAlreadyPresent((GraphQLType)this.gqlInputObjectType);
    }

    @Override
    public GraphQLFieldDefinition newField(String fieldName, String description) {
        return this.buildFieldDefinition(fieldName, this.gqlInputObjectType);
    }

    public GraphQLFieldDefinition newField() {
        String fieldName = String.format("%s%s%s", this.graphqlConfiguration.getLookup().getFieldNamePrefix(), TypeNames.objectTypeFieldNameFor(this.objectSpecification), this.graphqlConfiguration.getLookup().getFieldNameSuffix());
        return this.buildFieldDefinition(fieldName, this.gqlInputObjectType);
    }

    private GraphQLFieldDefinition buildFieldDefinition(String fieldName, GraphQLInputObjectType gqlInputObjectType) {
        ObjectSpecification objectSpec = this.getObjectSpecification();
        return GraphQLFieldDefinition.newFieldDefinition().name(fieldName).type(this.context.typeMapper.outputTypeFor(objectSpec, this.getSchemaType())).argument(GraphQLArgument.newArgument().name(this.graphqlConfiguration.getLookup().getArgName()).type((GraphQLInputType)gqlInputObjectType).build()).build();
    }

    private void addMembers() {
        this.objectSpecification.streamProperties(MixedIn.INCLUDED).filter(x$0 -> this.inApiScope((ObjectAssociation)x$0)).forEach(prop -> this.properties.add(this.addChildFieldFor(this.schemaStrategy.newProperty(this, (OneToOneAssociation)prop, this.context))));
        this.objectSpecification.streamCollections(MixedIn.INCLUDED).filter(x$0 -> this.inApiScope((ObjectAssociation)x$0)).forEach(coll -> this.collections.add(this.addChildFieldFor(this.schemaStrategy.newCollection(this, (OneToManyAssociation)coll, this.context))));
        this.objectSpecification.streamActions(this.context.getActionScope(), MixedIn.INCLUDED).filter(x$0 -> this.inApiScope((ObjectAction)x$0)).filter(act -> this.schemaStrategy.shouldInclude(this.graphqlConfiguration.getApiVariant(), (ObjectAction)act)).forEach(act -> this.actions.add(this.addChildFieldFor(this.schemaStrategy.newAction(this, (ObjectAction)act, this.context))));
    }

    private ActionScope determineActionScope() {
        return this.context.causewaySystemEnvironment.getDeploymentType().isProduction() ? ActionScope.PRODUCTION : ActionScope.PROTOTYPE;
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.meta == null) {
            return;
        }
        this.meta.addDataFetcher(this);
        this.properties.forEach(property -> property.addDataFetcher(this));
        this.collections.forEach(collection -> collection.addDataFetcher(this));
        this.actions.forEach(action -> action.addDataFetcher(this));
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Object target = dataFetchingEnvironment.getArgument("object");
        return ObjectFeatureUtils.asPojo(this.getObjectSpecification(), target, new Environment.For(dataFetchingEnvironment), this.context).orElse(null);
    }

    public String toString() {
        return this.objectSpecification.getLogicalTypeName();
    }

    @Override
    public ObjectSpecification getObjectSpecification() {
        return this.objectSpecification;
    }

    public GraphQLInputObjectType getGqlInputObjectType() {
        return this.gqlInputObjectType;
    }
}

