/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichAssociation;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichCollectionDatatype;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichCollectionGet;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichMemberDisabled;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichMemberHidden;

public class RichCollection
extends RichAssociation<OneToManyAssociation, ObjectInteractor>
implements MemberInteractor<OneToManyAssociation> {
    private final RichMemberHidden<OneToManyAssociation> hidden;
    private final RichMemberDisabled<OneToManyAssociation> disabled;
    private final RichCollectionGet get;
    private final RichCollectionDatatype datatype;

    public RichCollection(ObjectInteractor objectInteractor, OneToManyAssociation otma, Context context) {
        super(objectInteractor, otma, TypeNames.collectionTypeNameFor(objectInteractor.getObjectSpecification(), otma, objectInteractor.getSchemaType()), context);
        if (this.isBuilt()) {
            this.hidden = null;
            this.disabled = null;
            this.get = null;
            this.datatype = null;
            return;
        }
        this.hidden = new RichMemberHidden<OneToManyAssociation>(this, context);
        this.addChildFieldFor(this.hidden);
        this.disabled = new RichMemberDisabled<OneToManyAssociation>(this, context);
        this.addChildFieldFor(this.disabled);
        this.get = new RichCollectionGet(this, context);
        this.addChildFieldFor(this.get);
        this.datatype = new RichCollectionDatatype(this, context);
        this.addChildFieldFor(this.datatype);
        this.buildObjectTypeAndField(otma.asciiId(), otma.getCanonicalDescription().orElse(otma.getCanonicalFriendlyName()));
    }

    @Override
    public ObjectSpecification getObjectSpecification() {
        return ((ObjectInteractor)this.interactor).getObjectSpecification();
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.hidden == null) {
            return;
        }
        this.hidden.addDataFetcher(this);
        this.disabled.addDataFetcher(this);
        this.get.addDataFetcher(this);
        this.datatype.addDataFetcher(this);
    }

    @Override
    public SchemaType getSchemaType() {
        return ((ObjectInteractor)this.interactor).getSchemaType();
    }
}

