/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.ElementCustom;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetClobChars;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetClobMimeType;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetClobName;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public class RichPropertyGetClob
extends ElementCustom {
    final MemberInteractor<OneToOneAssociation> memberInteractor;
    final RichPropertyGetClobName clobName;
    final RichPropertyGetClobMimeType clobMimeType;
    final RichPropertyGetClobChars clobChars;
    private final CausewayConfiguration.Viewer.Graphql graphqlConfiguration;

    public RichPropertyGetClob(MemberInteractor<OneToOneAssociation> memberInteractor, Context context) {
        super(TypeNames.propertyLobTypeNameFor(memberInteractor.getObjectSpecification(), (OneToOneAssociation)memberInteractor.getObjectMember(), memberInteractor.getSchemaType()), context);
        this.memberInteractor = memberInteractor;
        this.graphqlConfiguration = context.causewayConfiguration.getViewer().getGraphql();
        if (this.isBuilt()) {
            this.clobName = null;
            this.clobMimeType = null;
            this.clobChars = null;
            return;
        }
        this.clobName = new RichPropertyGetClobName(memberInteractor, context);
        this.addChildFieldFor(this.clobName);
        this.clobMimeType = new RichPropertyGetClobMimeType(memberInteractor, context);
        this.addChildFieldFor(this.clobMimeType);
        this.clobChars = this.isResourceNotForbidden() ? new RichPropertyGetClobChars(memberInteractor, context) : null;
        this.addChildFieldFor(this.clobChars);
        this.setField(GraphQLFieldDefinition.newFieldDefinition().name("get").type((GraphQLOutputType)this.buildObjectType()).build());
    }

    private boolean isResourceNotForbidden() {
        return this.graphqlConfiguration.getResources().getResponseType() != CausewayConfiguration.Viewer.Graphql.ResponseType.FORBIDDEN;
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        return BookmarkedPojo.sourceFrom(dataFetchingEnvironment, this.context);
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.clobName == null) {
            return;
        }
        this.clobName.addDataFetcher(this);
        this.clobMimeType.addDataFetcher(this);
        if (this.clobChars != null) {
            this.clobChars.addDataFetcher(this);
        }
    }
}

