/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.common.query;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Environment;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public final class ObjectFeatureUtils {
    static Optional<Object> asPojo(ObjectSpecification elementType, Object argumentValueObj, Environment environment, Context context) {
        Map argumentValue = (Map)argumentValueObj;
        String refValue = (String)argumentValue.get("ref");
        if (refValue != null) {
            String key = ObjectFeatureUtils.keyFor(refValue);
            BookmarkedPojo bookmarkedPojo = (BookmarkedPojo)environment.getGraphQlContext().get((Object)key);
            if (bookmarkedPojo == null) {
                throw new IllegalArgumentException(String.format("Could not find object referenced '%s' in the execution context; was it saved previously using \"saveAs\" ?", refValue));
            }
            Class<?> targetPojoClass = bookmarkedPojo.getTargetPojo().getClass();
            ObjectSpecification targetPojoSpec = context.specificationLoader.loadSpecification(targetPojoClass);
            if (targetPojoSpec == null) {
                throw new IllegalArgumentException(String.format("The object referenced '%s' is not part of the metamodel (has class '%s')", refValue, targetPojoClass.getCanonicalName()));
            }
            if (!elementType.isPojoCompatible(bookmarkedPojo.getTargetPojo())) {
                throw new IllegalArgumentException(String.format("The object referenced '%s' has a type '%s' that is not assignable to the required type '%s'", refValue, targetPojoSpec.logicalTypeName(), elementType.logicalTypeName()));
            }
            return Optional.of(bookmarkedPojo).map(BookmarkedPojo::getTargetPojo);
        }
        String idValue = (String)argumentValue.get("id");
        if (idValue != null) {
            Optional<Bookmark> bookmarkIfAny;
            Class paramClass = elementType.getCorrespondingClass();
            if (elementType.isAbstract()) {
                ObjectSpecification objectSpecArg = (ObjectSpecification)argumentValue.get("logicalTypeName");
                if (objectSpecArg == null) {
                    throw new IllegalArgumentException(String.format("The 'logicalTypeName' is required along with the 'id', because the input type '%s' is abstract", elementType.logicalTypeName()));
                }
                bookmarkIfAny = Optional.of(Bookmark.forLogicalTypeNameAndIdentifier((String)objectSpecArg.logicalTypeName(), (String)idValue));
            } else {
                bookmarkIfAny = context.bookmarkService.bookmarkFor(paramClass, idValue);
            }
            return bookmarkIfAny.map(arg_0 -> ((BookmarkService)context.bookmarkService).lookup(arg_0)).filter(Optional::isPresent).map(Optional::get);
        }
        throw new IllegalArgumentException("Either 'id' or 'ref' must be specified for a DomainObject input type");
    }

    public static Can<ManagedObject> argumentManagedObjectsFor(Environment environment, ObjectAction objectAction, Context context) {
        Map<String, Object> argumentPojos = environment.getArguments();
        Can parameters = objectAction.getParameters();
        return parameters.map(oap -> {
            ObjectSpecification elementType = oap.getElementType();
            Object argumentValue = argumentPojos.get(oap.asciiId());
            switch (elementType.getBeanSort()) {
                case VALUE: {
                    return ObjectFeatureUtils.adaptValue(oap, argumentValue, context);
                }
                case ENTITY: 
                case VIEW_MODEL: {
                    if (argumentValue == null) {
                        return ManagedObject.empty((ObjectSpecification)elementType);
                    }
                }
                case ABSTRACT: {
                    List pojoOrPojoList;
                    if (argumentValue instanceof List) {
                        List argumentValueList = (List)argumentValue;
                        pojoOrPojoList = argumentValueList.stream().map(value -> ObjectFeatureUtils.asPojo(oap.getElementType(), value, environment, context)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                    } else {
                        pojoOrPojoList = ObjectFeatureUtils.asPojo(oap.getElementType(), argumentValue, environment, context).orElse(null);
                    }
                    return ManagedObject.adaptParameter((ObjectActionParameter)oap, pojoOrPojoList);
                }
            }
            throw new IllegalArgumentException(String.format("Cannot handle an input type for %s; beanSort is %s", elementType.getFullIdentifier(), elementType.getBeanSort()));
        });
    }

    private static ManagedObject adaptValue(ObjectActionParameter oap, Object argumentValue, Context context) {
        ObjectSpecification elementType = oap.getElementType();
        if (argumentValue == null) {
            return ManagedObject.empty((ObjectSpecification)elementType);
        }
        Object argPojo = context.typeMapper.unmarshal(argumentValue, elementType);
        return ManagedObject.adaptParameter((ObjectActionParameter)oap, (Object)argPojo);
    }

    public static String keyFor(String ref) {
        return ObjectFeatureUtils.class.getName() + "#" + ref;
    }

    @Generated
    private ObjectFeatureUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

