/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.viewer.integration;

import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import java.util.concurrent.CompletableFuture;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.viewer.graphql.applib.auth.UserMementoProvider;
import org.springframework.stereotype.Service;

@Service
public class AsyncExecutionStrategyResolvingWithinInteraction
extends AsyncExecutionStrategy {
    private final InteractionService interactionService;
    private final UserMementoProvider userMementoProvider;

    public AsyncExecutionStrategyResolvingWithinInteraction(InteractionService interactionService, UserMementoProvider userMementoProvider) {
        this.interactionService = interactionService;
        this.userMementoProvider = userMementoProvider;
    }

    protected CompletableFuture<FieldValueInfo> resolveFieldWithInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        UserMemento userMemento = this.userMementoProvider.userMemento(executionContext, parameters);
        if (userMemento != null) {
            return (CompletableFuture)this.interactionService.call(InteractionContext.builder().user(userMemento).build(), () -> super.resolveFieldWithInfo(executionContext, parameters));
        }
        return (CompletableFuture)this.interactionService.callAnonymous(() -> super.resolveFieldWithInfo(executionContext, parameters));
    }
}

