/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.applib.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;

public final class JsonMapper {
    private static Map<PrettyPrinting, JsonMapper> instanceByConfig = new ConcurrentHashMap<PrettyPrinting, JsonMapper>();
    private final ObjectMapper objectMapper;

    public static String getEntityAsStringFrom(Response response) {
        Object result = response.getEntity();
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return (String)response.readEntity(String.class);
    }

    private static ObjectMapper createObjectMapper(PrettyPrinting prettyPrinting) {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule jsonModule = new SimpleModule("json", new Version(1, 0, 0, null, "org.apache", "causeway"));
        jsonModule.addDeserializer(JsonRepresentation.class, (JsonDeserializer)new JsonRepresentationDeserializer());
        jsonModule.addSerializer(JsonRepresentation.class, (JsonSerializer)new JsonRepresentationSerializer());
        objectMapper.registerModule((Module)jsonModule);
        if (prettyPrinting == PrettyPrinting.ENABLE) {
            objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        }
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static final JsonMapper instance() {
        return JsonMapper.instance(PrettyPrinting.ENABLE);
    }

    public static final JsonMapper instance(PrettyPrinting prettyPrinting) {
        JsonMapper jsonMapper = instanceByConfig.get((Object)prettyPrinting);
        if (jsonMapper != null) {
            return jsonMapper;
        }
        JsonMapper mapper = new JsonMapper(prettyPrinting);
        instanceByConfig.put(prettyPrinting, mapper);
        return mapper;
    }

    private JsonMapper(PrettyPrinting prettyPrinting) {
        this.objectMapper = JsonMapper.createObjectMapper(prettyPrinting);
    }

    public JsonRepresentation read(String json) throws JsonParseException, JsonMappingException, IOException {
        return this.read(json, JsonRepresentation.class);
    }

    public <T> T read(String json, Class<T> requiredType) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.objectMapper.readValue(json, requiredType);
    }

    public <T> T read(Response response, Class<T> requiredType) throws JsonParseException, JsonMappingException, IOException {
        String entity = JsonMapper.getEntityAsStringFrom(response);
        if (entity == null) {
            return null;
        }
        return this.read(entity, requiredType);
    }

    public String write(Object object) throws JsonGenerationException, JsonMappingException, IOException {
        return this.objectMapper.writeValueAsString(object);
    }

    private static final class JsonRepresentationDeserializer
    extends JsonDeserializer<JsonRepresentation> {
        private JsonRepresentationDeserializer() {
        }

        public JsonRepresentation deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new JsonRepresentation(node);
        }
    }

    private static final class JsonRepresentationSerializer
    extends JsonSerializer<Object> {
        private JsonRepresentationSerializer() {
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            JsonRepresentation jsonRepresentation = (JsonRepresentation)value;
            JsonNode jsonNode = jsonRepresentation.asJsonNode();
            jgen.writeTree((TreeNode)jsonNode);
        }
    }

    public static enum PrettyPrinting {
        ENABLE,
        DISABLE;

    }
}

