/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.service.acceptheader;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.causeway.applib.annotation.InteractionScope;
import org.apache.causeway.applib.services.acceptheader.AcceptHeaderService;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.ro.AcceptHeaderServiceForRest")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="ForRest")
@InteractionScope
public class AcceptHeaderServiceForRest
implements AcceptHeaderService {
    private static ThreadLocal<List<MediaType>> mediaTypesByThread = new ThreadLocal();

    private static void setMediaTypes(List<MediaType> mediaTypes) {
        mediaTypesByThread.set(mediaTypes);
    }

    private static void removeMediaTypes() {
        mediaTypesByThread.remove();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return mediaTypesByThread.get();
    }

    @Component
    @Provider
    public static class ResponseFilter
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            AcceptHeaderServiceForRest.removeMediaTypes();
        }
    }

    @Component
    @Provider
    public static class RequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            List acceptableMediaTypes = requestContext.getAcceptableMediaTypes();
            List<MediaType> mediaTypes = _NullSafe.stream((Collection)acceptableMediaTypes).filter(_NullSafe::isPresent).collect(Collectors.toList());
            AcceptHeaderServiceForRest.setMediaTypes(mediaTypes);
        }
    }
}

