/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.util.PathNode;

public final class LinkFollowSpecs {
    private final List<List<PathNode>> pathSpecs;
    private final Mode mode;
    private final List<PathNode> criteriaSpecs;

    public static final LinkFollowSpecs create(List<List<String>> links) {
        List<List<PathNode>> specs = LinkFollowSpecs.asFollowSpecs(links);
        return new LinkFollowSpecs(specs, Mode.FOLLOWING, null);
    }

    private static final List<List<PathNode>> asFollowSpecs(List<List<String>> links) {
        return _NullSafe.stream(links).map(_NullSafe::stream).map(pathPartStream -> pathPartStream.map(PathNode::parse).collect(Collectors.toCollection(ArrayList::new))).collect(Collectors.toCollection(ArrayList::new));
    }

    private LinkFollowSpecs(List<List<PathNode>> pathSpecs, Mode mode, List<PathNode> criteriaSpecs) {
        this.pathSpecs = pathSpecs;
        this.mode = mode;
        this.criteriaSpecs = criteriaSpecs;
    }

    public LinkFollowSpecs follow(String pathTemplate, Object ... args) {
        String path = String.format(pathTemplate, args);
        if (path == null) {
            return LinkFollowSpecs.terminated();
        }
        if (this.mode == Mode.TERMINATED) {
            return LinkFollowSpecs.terminated();
        }
        PathNode candidate = PathNode.parse((String)path);
        if (this.mode == Mode.FOLLOWING) {
            ArrayList remainingPathSpecs = _Lists.newArrayList();
            ArrayList firstSpecs = _Lists.newArrayList();
            for (List<PathNode> spec : this.pathSpecs) {
                PathNode first;
                if (spec.isEmpty() || !candidate.equals((Object)(first = spec.get(0)))) continue;
                List<PathNode> remaining = spec.subList(1, spec.size());
                firstSpecs.add(first);
                remainingPathSpecs.add(remaining);
            }
            if (!remainingPathSpecs.isEmpty()) {
                return new LinkFollowSpecs(remainingPathSpecs, Mode.FOLLOWING, firstSpecs);
            }
            return LinkFollowSpecs.terminated();
        }
        return LinkFollowSpecs.terminated();
    }

    private static LinkFollowSpecs terminated() {
        return new LinkFollowSpecs(Collections.emptyList(), Mode.TERMINATED, Collections.emptyList());
    }

    boolean isFollowing() {
        return this.mode == Mode.FOLLOWING;
    }

    public boolean isTerminated() {
        return this.mode == Mode.TERMINATED;
    }

    public boolean matches(JsonRepresentation jsonRepr) {
        if (!this.isFollowing()) {
            return false;
        }
        if (this.criteriaSpecs == null) {
            return true;
        }
        for (PathNode criteriaSpec : this.criteriaSpecs) {
            if (!criteriaSpec.matches(jsonRepr)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mode + " : " + this.criteriaSpecs + " : " + this.pathSpecs;
    }

    private static enum Mode {
        FOLLOWING,
        TERMINATED;

    }
}

