/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedMember;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.service.valuerender.JsonValueConverter;

public class ObjectPropertyReprRenderer
extends AbstractObjectMemberReprRenderer<OneToOneAssociation> {
    public ObjectPropertyReprRenderer(IResourceContext context) {
        this(context, (LinkFollowSpecs)null, (String)null, JsonRepresentation.newMap((String[])new String[0]));
    }

    public ObjectPropertyReprRenderer(IResourceContext context, LinkFollowSpecs linkFollower, String propertyId, JsonRepresentation representation) {
        super(context, linkFollower, propertyId, RepresentationType.OBJECT_PROPERTY, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        LinkFollowSpecs followValue = this.getLinkFollowSpecs().follow("value", new Object[0]);
        this.addValue(followValue);
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addChoices();
            this.addExtensionsCausewayProprietaryChangedObjects();
        }
        return this.representation;
    }

    private void addValue(LinkFollowSpecs linkFollower) {
        ManagedObject valueAdapterIfAny = ((OneToOneAssociation)this.objectMember).get(this.objectAdapter, this.getInteractionInitiatedBy());
        ManagedObject valueAdapter = ManagedObjects.isSpecified((ManagedObject)valueAdapterIfAny) ? valueAdapterIfAny : ManagedObject.empty((ObjectSpecification)((OneToOneAssociation)this.objectMember).getElementType());
        ObjectSpecification spec = valueAdapter.objSpec();
        if (spec.isValue()) {
            this.jsonValueEncoder.appendValueAndFormat(valueAdapter, this.representation, JsonValueConverter.Context.of((ObjectFeature)this.objectMember, this.resourceContext.config().isSuppressMemberExtensions()));
            return;
        }
        if (valueAdapter.getPojo() == null) {
            NullNode value = NullNode.getInstance();
            this.representation.mapPutJsonNode("value", (JsonNode)value);
            return;
        }
        boolean eagerlyRender = Facets.defaultViewIsTable((ObjectFeature)this.objectMember) && this.resourceContext.canEagerlyRender(valueAdapter) || linkFollower != null && !linkFollower.isTerminated();
        String title = valueAdapter.getTitle();
        LinkBuilder valueLinkBuilder = DomainObjectReprRenderer.newLinkToBuilder(this.resourceContext, Rel.VALUE, valueAdapter).withTitle(title);
        if (eagerlyRender) {
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.resourceContext, linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(valueAdapter);
            if (this.mode.isEventSerialization()) {
                renderer.asEventSerialization();
            }
            valueLinkBuilder.withValue(renderer.render());
        }
        JsonRepresentation valueJsonRepr = valueLinkBuilder.build();
        this.representation.mapPutJsonRepresentation("value", valueJsonRepr);
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        JsonRepresentation representation = JsonRepresentation.newMap((String[])new String[0]);
        ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.getResourceContext(), this.getLinkFollowSpecs(), null, representation);
        renderer.with((ManagedMember)ManagedProperty.of((ManagedObject)this.objectAdapter, (OneToOneAssociation)((OneToOneAssociation)this.objectMember), (Where)this.where)).asFollowed();
        detailsLink.mapPutJsonRepresentation("value", renderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        this.objectMemberType.getMutators().values().forEach(this::addLinkFor);
    }

    private ObjectPropertyReprRenderer addChoices() {
        Object propertyChoices = this.propertyChoices();
        if (propertyChoices != null) {
            this.representation.mapPut("choices", propertyChoices);
        }
        return this;
    }

    private Object propertyChoices() {
        Can choiceAdapters = ((OneToOneAssociation)this.objectMember).getChoices(this.objectAdapter, this.getInteractionInitiatedBy());
        if (choiceAdapters == null || choiceAdapters.isEmpty()) {
            return null;
        }
        ArrayList list = _Lists.newArrayList();
        for (ManagedObject choiceAdapter : choiceAdapters) {
            list.add(DomainObjectReprRenderer.valueOrRef(this.resourceContext, (ObjectFeature)this.objectMember, super.getJsonValueEncoder(), choiceAdapter));
        }
        return list;
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.resourceContext.config().isSuppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = PropertyDescriptionReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.DESCRIBEDBY, this.objectAdapter.objSpec(), (OneToOneAssociation)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void putExtensionsCausewayProprietary() {
    }
}

