/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domaintypes;

import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.AbstractTypeMemberReprRenderer;
import org.apache.causeway.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public class CollectionDescriptionReprRenderer
extends AbstractTypeMemberReprRenderer<OneToManyAssociation> {
    public static LinkBuilder newLinkToBuilder(IResourceContext resourceContext, Rel rel, ObjectSpecification objectSpecification, OneToManyAssociation collection) {
        String domainType = objectSpecification.logicalTypeName();
        String collectionId = collection.getId();
        String url = "domain-types/" + domainType + "/collections/" + collectionId;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.COLLECTION_DESCRIPTION, url, new Object[0]);
    }

    public CollectionDescriptionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.COLLECTION_DESCRIPTION, representation);
    }

    @Override
    protected void addLinksSpecificToFeature() {
        this.addLinkToElementTypeIfAny();
    }

    @Override
    protected void putExtensionsSpecificToFeature() {
        this.putExtensionsName();
        this.putExtensionsDescriptionIfAvailable();
    }

    private void addLinkToElementTypeIfAny() {
        ObjectSpecification elementTypeSpec = ((OneToManyAssociation)this.getObjectFeature()).getElementType();
        if (elementTypeSpec == null) {
            return;
        }
        this.getLinks().arrayAdd(DomainTypeReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.ELEMENT_TYPE, elementTypeSpec).build());
    }
}

