/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public record RequestParams(@NonNull Nature nature, @Nullable String raw) {
    public static RequestParams ofRequestBody(InputStream is) {
        return new RequestParams(Nature.REQUEST_BODY, RequestParams.asStringUtf8(is));
    }

    public static RequestParams ofQueryString(String queryString) {
        return new RequestParams(Nature.QUERY_STRING, queryString);
    }

    public static RequestParams ofEmptyQueryString() {
        return new RequestParams(Nature.QUERY_STRING, "");
    }

    public JsonRepresentation asMap() {
        return RequestParams.readAsMap(this.raw, this.nature.name());
    }

    private static String asStringUtf8(InputStream body) {
        try {
            return _Strings.ofBytes((byte[])_Bytes.of((InputStream)body), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not read body", new Object[0]);
        }
    }

    private static JsonRepresentation readAsMap(String rawArgs, String argsNature) {
        if (rawArgs == null) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        String bodyTrimmed = rawArgs.trim();
        if (bodyTrimmed.isEmpty()) {
            return JsonRepresentation.newMap((String[])new String[0]);
        }
        try {
            JsonRepresentation jsonRepr = JsonMapper.instance().read(rawArgs);
            if (!jsonRepr.isMap()) {
                throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "could not read %s as a JSON map", argsNature);
            }
            return jsonRepr;
        }
        catch (JsonParseException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not parse %s", argsNature);
        }
        catch (JsonMappingException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)((Object)e), "could not read %s as JSON", argsNature);
        }
        catch (IOException e) {
            throw RestfulObjectsApplicationException.createWithCauseAndMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, e, "could not parse %s", argsNature);
        }
    }

    static enum Nature {
        REQUEST_BODY,
        QUERY_STRING;

    }
}

