/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.rendering.domainobjects;

import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.viewer.restfulobjects.applib.Rel;
import org.apache.causeway.viewer.restfulobjects.applib.RepresentationType;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.causeway.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;

public class DomainObjectLinkTo
implements ObjectAdapterLinkTo {
    protected IResourceContext resourceContext;
    protected ManagedObject objectAdapter;

    @Override
    public final DomainObjectLinkTo usingUrlBase(IResourceContext resourceContext) {
        this.resourceContext = resourceContext;
        return this;
    }

    @Override
    public ObjectAdapterLinkTo with(ManagedObject objectAdapter) {
        this.objectAdapter = objectAdapter;
        return this;
    }

    @Override
    public LinkBuilder builder() {
        return this.builder(null);
    }

    @Override
    public LinkBuilder builder(Rel rel) {
        LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.resourceContext, this.relElseDefault(rel).getName(), RepresentationType.DOMAIN_OBJECT, this.linkRef(new StringBuilder()).toString(), new Object[0]);
        linkBuilder.withTitle(this.objectAdapter.getTitle());
        return linkBuilder;
    }

    protected StringBuilder linkRef(StringBuilder buf) {
        String objectRef = ManagedObjects.stringifyElseUnidentified((ManagedObject)this.objectAdapter, (String)"/");
        return buf.append("objects/").append(objectRef);
    }

    protected Rel relElseDefault(Rel rel) {
        return rel != null ? rel : this.defaultRel();
    }

    protected Rel defaultRel() {
        return Rel.VALUE;
    }

    @Override
    public final LinkBuilder memberBuilder(Rel rel, MemberType memberType, ObjectMember objectMember, String ... parts) {
        return this.memberBuilder(rel, memberType, objectMember, memberType.getRepresentationType(), parts);
    }

    @Override
    public final LinkBuilder memberBuilder(Rel rel, MemberType memberType, ObjectMember objectMember, RepresentationType representationType, String ... parts) {
        StringBuilder buf = this.linkRef(new StringBuilder());
        buf.append("/").append(memberType.getUrlPart()).append(objectMember.getId());
        for (String part : parts) {
            if (part == null) continue;
            buf.append("/").append(part);
        }
        String url = buf.toString();
        return LinkBuilder.newBuilder(this.resourceContext, rel.andParam(memberType.getName(), objectMember.getId()), representationType, url, new Object[0]);
    }
}

