/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.restfulobjects.viewer.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Railway;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.causeway.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.causeway.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.causeway.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.causeway.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.causeway.viewer.restfulobjects.viewer.resources.JsonParserHelper;

public class ObjectActionArgHelper {
    public static Can<Railway<InteractionVeto, ManagedObject>> parseArguments(IResourceContext resourceContext, ObjectAction action, JsonRepresentation arguments) {
        List<JsonRepresentation> jsonArgList = ObjectActionArgHelper.argListFor(action, arguments);
        Can parameters = action.getParameters();
        return (Can)IntStream.range(0, jsonArgList.size()).mapToObj(argIndex -> {
            JsonRepresentation argRepr = (JsonRepresentation)jsonArgList.get(argIndex);
            ObjectActionParameter paramMeta = (ObjectActionParameter)parameters.getElseFail(argIndex);
            ObjectSpecification paramSpec = paramMeta.getElementType();
            Try.Success tryArgument = paramMeta.isOptional() && argRepr == null ? Try.success((Object)ManagedObject.empty((ObjectSpecification)paramSpec)) : Try.call(() -> new JsonParserHelper(resourceContext, paramSpec).objectAdapterFor(argRepr)).mapSuccessAsNullable(success -> success != null ? success : ManagedObject.empty((ObjectSpecification)paramSpec));
            Railway objectOrVeto = (Railway)tryArgument.fold(exception -> Railway.failure((Object)InteractionVeto.actionParamInvalid((String)String.format("exception when parsing paramNr %d [%s]: %s", argIndex, argRepr, exception))), success -> Railway.success((Object)((ManagedObject)success.orElseThrow())));
            return objectOrVeto;
        }).collect(Can.toCan());
    }

    private static List<JsonRepresentation> argListFor(ObjectAction action, JsonRepresentation arguments) {
        arguments.streamMapEntries().map(Map.Entry::getKey).filter(argName -> !argName.startsWith("x-ro")).forEach(argName -> {
            if (action.getParameterById(argName) == null) {
                String reason = String.format("Argument '%s' found but no such parameter", argName);
                arguments.mapPutString("x-ro-invalidReason", reason);
                throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)arguments, (String)reason, (Object[])new Object[0]);
            }
        });
        ArrayList argList = _Lists.newArrayList();
        Can parameters = action.getParameters();
        for (ObjectActionParameter param : parameters) {
            String paramId = param.getId();
            JsonRepresentation argRepr = arguments.getRepresentation(paramId, new Object[0]);
            if (argRepr == null && !param.isOptional()) {
                String reason = String.format("No argument found for (mandatory) parameter '%s'", paramId);
                arguments.mapPutString("x-ro-invalidReason", reason);
                throw RestfulObjectsApplicationException.createWithBody((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (JsonRepresentation)arguments, (String)reason, (Object[])new Object[0]);
            }
            argList.add(argRepr);
        }
        return argList;
    }

    @Generated
    private ObjectActionArgHelper() {
    }

    @Generated
    public static ObjectActionArgHelper of() {
        return new ObjectActionArgHelper();
    }
}

