/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.metamodel.commons.ViewOrEditMode;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedValue;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.hints.HasRenderingHints;
import org.apache.causeway.viewer.commons.model.hints.RenderingHint;
import org.apache.causeway.viewer.commons.model.scalar.UiScalar;
import org.apache.causeway.viewer.wicket.model.models.FormExecutorContext;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarUnwrappingModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models._Xray;
import org.apache.causeway.viewer.wicket.model.value.ConverterBasedOnValueSemantics;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class ScalarModel
extends ChainingModel<ManagedObject>
implements HasRenderingHints,
UiScalar,
FormExecutorContext {
    private static final long serialVersionUID = 1L;
    private final UiObjectWkt parentEntityModel;
    private ViewOrEditMode viewOrEditMode;
    private RenderingHint renderingHint;
    private InlinePromptContext inlinePromptContext;
    protected transient AssociatedActions associatedActions;

    protected ScalarModel(UiObjectWkt parentUiObject, ViewOrEditMode viewOrEdit) {
        this(parentUiObject, viewOrEdit, RenderingHint.REGULAR);
    }

    protected ScalarModel(@NonNull UiObjectWkt parentEntityModel, @NonNull ViewOrEditMode viewOrEdit, @NonNull RenderingHint renderingHint) {
        super((Object)parentEntityModel);
        if (parentEntityModel == null) {
            throw new NullPointerException("parentEntityModel is marked non-null but is null");
        }
        if (viewOrEdit == null) {
            throw new NullPointerException("viewOrEdit is marked non-null but is null");
        }
        if (renderingHint == null) {
            throw new NullPointerException("renderingHint is marked non-null but is null");
        }
        this.parentEntityModel = parentEntityModel;
        this.renderingHint = renderingHint;
        this.viewOrEditMode = viewOrEdit;
    }

    public final Either<ScalarParameterModel, ScalarPropertyModel> getSpecialization() {
        return this.isParameter() ? Either.left((Object)((ScalarParameterModel)this)) : Either.right((Object)((ScalarPropertyModel)this));
    }

    public <T> IModel<T> unwrapped(Class<T> type) {
        return new ScalarUnwrappingModel<T>(type, this);
    }

    public final ManagedObject getObject() {
        ManagedValue proposedValue = this.proposedValue();
        return ManagedObjects.nullToEmpty((ObjectSpecification)proposedValue.getElementType(), (ManagedObject)((ManagedObject)proposedValue.getValue().getValue()));
    }

    public final void setObject(ManagedObject newValue) {
        this.proposedValue().update(oldValue -> {
            _Xray.onSclarModelUpdate(this, oldValue, newValue);
            return newValue;
        });
    }

    public final UiObjectWkt getParentUiModel() {
        return this.parentEntityModel;
    }

    public final boolean isEmpty() {
        return ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)((ManagedObject)this.proposedValue().getValue().getValue()));
    }

    public final boolean isScalarTypeAnyOf(Can<Class<?>> requiredClasses) {
        String fullName = this.getElementType().getFullIdentifier();
        return requiredClasses.stream().map(Class::getName).anyMatch(fullName::equals);
    }

    public final boolean isScalarTypeSubtypeOf(Class<?> requiredClass) {
        Class scalarType = this.getElementType().getCorrespondingClass();
        return _NullSafe.streamNullable(requiredClass).anyMatch(x -> x.isAssignableFrom(scalarType));
    }

    public abstract ManagedValue proposedValue();

    public abstract String validate(ManagedObject var1);

    @Override
    public final PromptStyle getPromptStyle() {
        return Facets.promptStyleOrElse((ObjectFeature)this.getMetaModel(), (PromptStyle)PromptStyle.INLINE);
    }

    public final <T> Optional<IConverter<T>> getConverter(Class<T> requiredType) {
        ObjectFeature propOrParam = this.getMetaModel();
        return Optional.of(new ConverterBasedOnValueSemantics<T>(requiredType, propOrParam, this.getViewOrEditMode()));
    }

    public final boolean isInlinePrompt() {
        return this.hasAssociatedActionWithInlineAsIfEdit() || this.getPromptStyle().isInline() && this.isViewingMode() && !this.disabledReason().isPresent();
    }

    public final boolean isShowMandatoryIndicator() {
        return this.isRequired() && !this.disabledReason().isPresent();
    }

    @Override
    public InlinePromptContext getInlinePromptContext() {
        return this.inlinePromptContext;
    }

    public void setInlinePromptContext(InlinePromptContext inlinePromptContext) {
        if (this.inlinePromptContext != null) {
            return;
        }
        this.inlinePromptContext = inlinePromptContext;
    }

    public final AssociatedActions getAssociatedActions() {
        if (this.associatedActions == null) {
            this.associatedActions = new AssociatedActions(this.calcAssociatedActions());
        }
        return this.associatedActions;
    }

    public final boolean hasAssociatedActionWithInlineAsIfEdit() {
        return this.getAssociatedActions().getFirstAssociatedWithInlineAsIfEdit().isPresent();
    }

    protected abstract Can<ObjectAction> calcAssociatedActions();

    public final OptionalInt multilineNumberOfLines() {
        return Facets.multilineNumberOfLines((ObjectFeature)this.getMetaModel());
    }

    public final OptionalInt maxLength() {
        return Facets.maxLength((FacetHolder)this.getElementType());
    }

    public final OptionalInt typicalLength() {
        return Facets.typicalLength((ObjectSpecification)this.getElementType(), (OptionalInt)this.maxLength());
    }

    public String toString() {
        return this.toStringOf();
    }

    protected abstract String toStringOf();

    public ViewOrEditMode getViewOrEditMode() {
        return this.viewOrEditMode;
    }

    public void setViewOrEditMode(ViewOrEditMode viewOrEditMode) {
        this.viewOrEditMode = viewOrEditMode;
    }

    public RenderingHint getRenderingHint() {
        return this.renderingHint;
    }

    public static class AssociatedActions {
        private final Optional<ObjectAction> firstAssociatedWithInlineAsIfEdit;
        private final List<ObjectAction> remainingAssociated;

        AssociatedActions(Can<ObjectAction> allAssociated) {
            this.firstAssociatedWithInlineAsIfEdit = AssociatedActions.firstAssociatedActionWithInlineAsIfEdit(allAssociated);
            this.remainingAssociated = this.firstAssociatedWithInlineAsIfEdit.isPresent() ? allAssociated.remove((Object)this.firstAssociatedWithInlineAsIfEdit.get()).toList() : allAssociated.toList();
        }

        private static Optional<ObjectAction> firstAssociatedActionWithInlineAsIfEdit(Can<ObjectAction> objectActions) {
            return objectActions.stream().filter(act -> ObjectAction.Util.promptStyleFor((ObjectAction)act).isInlineAsIfEdit()).findFirst();
        }

        public Optional<ObjectAction> getFirstAssociatedWithInlineAsIfEdit() {
            return this.firstAssociatedWithInlineAsIfEdit;
        }

        public List<ObjectAction> getRemainingAssociated() {
            return this.remainingAssociated;
        }
    }
}

