/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.applib.exceptions.unrecoverable.ObjectNotFoundException;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.hint.HintStore;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.core.metamodel.commons.ViewOrEditMode;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.facets.object.icon.ObjectIcon;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.spec.feature.memento.PropertyMemento;
import org.apache.causeway.viewer.commons.model.hints.RenderingHint;
import org.apache.causeway.viewer.commons.model.object.UiObject;
import org.apache.causeway.viewer.wicket.model.hints.UiHintContainer;
import org.apache.causeway.viewer.wicket.model.models.BookmarkableModel;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.ImageResourceCache;
import org.apache.causeway.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.causeway.viewer.wicket.model.models._HintPageParameterSerializer;
import org.apache.causeway.viewer.wicket.model.models.interaction.BookmarkedObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.HasBookmarkedOwnerAbstract;
import org.apache.causeway.viewer.wicket.model.models.interaction.prop.PropertyInteractionWkt;
import org.apache.causeway.viewer.wicket.model.util.ComponentHintKey;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.springframework.lang.Nullable;

public class UiObjectWkt
extends HasBookmarkedOwnerAbstract<ManagedObject>
implements UiObject,
ObjectAdapterModel,
UiHintContainer,
BookmarkableModel {
    private static final Logger log = LogManager.getLogger(UiObjectWkt.class);
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = 1L;
    private ViewOrEditMode viewOrEditMode;
    private RenderingHint renderingHint;
    private transient Map<PropertyMemento, ScalarPropertyModel> propertyScalarModels;
    @Nullable
    private Bookmark contextBookmarkIfAny;
    private transient HintStore hintStore;
    private transient ImageResourceCache imageResourceCache;

    public static UiObjectWkt ofPageParameters(PageParameters pageParameters) {
        Bookmark bookmark = PageParameterUtils.toBookmark(pageParameters).orElse(null);
        return UiObjectWkt.ofBookmark(bookmark);
    }

    public static UiObjectWkt ofAdapter(@Nullable ManagedObject adapter) {
        return new UiObjectWkt(BookmarkedObjectWkt.ofAdapter(adapter), ViewOrEditMode.VIEWING, RenderingHint.REGULAR);
    }

    public static UiObjectWkt ofAdapterForCollection(ManagedObject adapter, @NonNull EntityCollectionModel.Variant variant) {
        if (variant == null) {
            throw new NullPointerException("variant is marked non-null but is null");
        }
        return new UiObjectWkt(BookmarkedObjectWkt.ofAdapter(adapter), ViewOrEditMode.VIEWING, variant.getTitleColumnRenderingHint());
    }

    public static UiObjectWkt ofBookmark(@Nullable Bookmark bookmark) {
        return new UiObjectWkt(BookmarkedObjectWkt.ofBookmark(bookmark), ViewOrEditMode.VIEWING, RenderingHint.REGULAR);
    }

    protected UiObjectWkt(ManagedObject adapter) {
        this(BookmarkedObjectWkt.ofAdapter(adapter), ViewOrEditMode.VIEWING, RenderingHint.REGULAR);
    }

    private UiObjectWkt(@NonNull BookmarkedObjectWkt bookmarkedObject, ViewOrEditMode viewOrEditMode, RenderingHint renderingHint) {
        super(bookmarkedObject);
        if (bookmarkedObject == null) {
            throw new NullPointerException("bookmarkedObject is marked non-null but is null");
        }
        this.viewOrEditMode = viewOrEditMode;
        this.renderingHint = renderingHint;
    }

    protected ManagedObject load() {
        return super.getBookmarkedOwner();
    }

    @Override
    public PageParameters getPageParameters() {
        return _HintPageParameterSerializer.hintStoreToPageParameters(this.hintStore(), this.getPageParametersWithoutUiHints(), this.getOwnerBookmark());
    }

    @Override
    public PageParameters getPageParametersWithoutUiHints() {
        return PageParameterUtils.createPageParametersForObject(this.getBookmarkedOwner());
    }

    public boolean isInlinePrompt() {
        return false;
    }

    @Override
    public String getHint(Component component, String keyName) {
        ComponentHintKey componentHintKey = ComponentHintKey.create(super.getMetaModelContext(), component, keyName);
        if (componentHintKey != null) {
            return componentHintKey.get(this.getOwnerBookmark());
        }
        return null;
    }

    @Override
    public void setHint(Component component, String keyName, String hintValue) {
        ComponentHintKey componentHintKey = ComponentHintKey.create(super.getMetaModelContext(), component, keyName);
        componentHintKey.set(this.getOwnerBookmark(), hintValue);
    }

    @Override
    public void clearHint(Component component, String attributeName) {
        this.setHint(component, attributeName, null);
    }

    public String getTitle() {
        return this.getManagedObject().getTitle();
    }

    @Override
    public Either<ObjectIcon, FontAwesomeLayers> getIcon() {
        return this.getManagedObject().eitherIconOrFaLayers();
    }

    public Either<ResourceReference, FontAwesomeLayers> getIconAsResourceReference() {
        return this.getIcon().mapLeft(objectIcon -> this.imageResourceCache().resourceReferenceForObjectIcon((ObjectIcon)objectIcon));
    }

    public ManagedObject getManagedObject() {
        return (ManagedObject)this.getObject();
    }

    private Map<PropertyMemento, ScalarPropertyModel> propertyScalarModels() {
        if (this.propertyScalarModels == null) {
            this.propertyScalarModels = _Maps.newHashMap();
        }
        return this.propertyScalarModels;
    }

    public ScalarModel getPropertyModel(OneToOneAssociation property, ViewOrEditMode viewOrEdit, RenderingHint renderingHint) {
        BookmarkedObjectWkt bookmarkedObjectModel = this.bookmarkedObjectModel();
        Object ownerPojo = bookmarkedObjectModel.asManagedObject().getPojo();
        if (ownerPojo == null) {
            throw new ObjectNotFoundException(bookmarkedObjectModel.getBookmark().getIdentifier());
        }
        PropertyMemento pm = property.getMemento();
        Map<PropertyMemento, ScalarPropertyModel> propertyScalarModels = this.propertyScalarModels();
        ScalarModel existingScalarModel = propertyScalarModels.get(pm);
        if (existingScalarModel != null) {
            return existingScalarModel;
        }
        PropertyInteractionWkt propertyInteractionModel = new PropertyInteractionWkt(bookmarkedObjectModel, pm.getIdentifier().getMemberLogicalName(), renderingHint.asWhere());
        long modelsAdded = propertyInteractionModel.streamPropertyUiModels().map(uiModel -> ScalarPropertyModel.wrap(uiModel, viewOrEdit, renderingHint)).peek(scalarModel -> log.debug("adding: {}", scalarModel)).filter(scalarModel -> propertyScalarModels.put(pm, (ScalarPropertyModel)scalarModel) == null).count();
        _Assert.assertEquals((Object)1L, (Object)modelsAdded, () -> String.format("unexpected number of propertyScalarModels added %d", modelsAdded));
        return propertyScalarModels.get(pm);
    }

    @Override
    public Stream<Bookmark> streamPropertyBookmarks() {
        ManagedObject candidateAdapter = (ManagedObject)this.getObject();
        return candidateAdapter.getSpecification().streamProperties(MixedIn.EXCLUDED).map(prop -> ManagedObjects.bookmark((ManagedObject)prop.get(candidateAdapter, InteractionInitiatedBy.PASS_THROUGH)).orElse(null)).filter(_NullSafe::isPresent);
    }

    public UiObjectWkt toEditingMode() {
        return this;
    }

    public UiObjectWkt toViewingMode() {
        return this;
    }

    protected void onDetach() {
        this.propertyScalarModels().values().forEach(ChainingModel::detach);
        super.onDetach();
        this.propertyScalarModels = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isContextAdapter(ManagedObject other) {
        Object object = this.$lock;
        synchronized (object) {
            return this.contextBookmarkIfAny == null ? false : Objects.equals(this.contextBookmarkIfAny, other.getBookmark().orElse(null));
        }
    }

    private HintStore hintStore() {
        this.hintStore = (HintStore)this.getMetaModelContext().loadServiceIfAbsent(HintStore.class, (Object)this.hintStore);
        return this.hintStore;
    }

    private ImageResourceCache imageResourceCache() {
        this.imageResourceCache = (ImageResourceCache)this.getMetaModelContext().loadServiceIfAbsent(ImageResourceCache.class, (Object)this.imageResourceCache);
        return this.imageResourceCache;
    }

    public ViewOrEditMode getViewOrEditMode() {
        return this.viewOrEditMode;
    }

    public void setViewOrEditMode(ViewOrEditMode viewOrEditMode) {
        this.viewOrEditMode = viewOrEditMode;
    }

    public RenderingHint getRenderingHint() {
        return this.renderingHint;
    }

    public void setContextBookmarkIfAny(@Nullable Bookmark contextBookmarkIfAny) {
        this.contextBookmarkIfAny = contextBookmarkIfAny;
    }
}

