/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.BookmarkPolicy;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.interactions.managed.ActionInteraction;
import org.apache.causeway.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.causeway.viewer.wicket.model.models.InlinePromptContext;
import org.apache.causeway.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.causeway.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.act.ActionInteractionWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.act.UiParameterWkt;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public final class ActionModelImpl
extends ChainingModel<ManagedObject>
implements ActionModel {
    private static final long serialVersionUID = 1L;
    private final ActionInteractionWkt delegate;

    public static ActionModelImpl forEntity(UiObjectWkt parentEntityModel, Identifier actionIdentifier, Where where, ScalarPropertyModel associatedWithPropertyIfAny, ScalarParameterModel associatedWithParameterIfAny, EntityCollectionModel associatedWithCollectionIfAny) {
        ActionInteractionWkt delegate = ActionInteractionWkt.forEntity(parentEntityModel, actionIdentifier, where, associatedWithPropertyIfAny, associatedWithParameterIfAny, associatedWithCollectionIfAny);
        return new ActionModelImpl(parentEntityModel, delegate);
    }

    private ActionModelImpl(UiObjectWkt parentEntityModel, ActionInteractionWkt delegate) {
        super((Object)parentEntityModel);
        this.delegate = delegate;
    }

    public ObjectAction getAction() {
        return this.delegate.getMetaModel();
    }

    public ActionInteraction getActionInteraction() {
        return this.delegate.actionInteraction();
    }

    @Override
    public PageParameters getPageParametersWithoutUiHints() {
        return PageParameterUtils.createPageParametersForAction(this.getParentObject(), this.getAction(), this.snapshotArgs());
    }

    @Override
    public PageParameters getPageParameters() {
        return this.getPageParametersWithoutUiHints();
    }

    @Override
    public BookmarkPolicy getBookmarkPolicy() {
        return BookmarkPolicy.AS_ROOT;
    }

    public UiObjectWkt getParentUiModel() {
        return (UiObjectWkt)super.getTarget();
    }

    @Override
    public Can<ManagedObject> snapshotArgs() {
        return this.delegate.parameterNegotiationModel().getParamValues();
    }

    @Override
    public ManagedObject executeActionAndReturnResult() {
        ParameterNegotiationModel pendingArgs = this.delegate.parameterNegotiationModel();
        ManagedObject result = this.delegate.actionInteraction().invokeWithRuleChecking(pendingArgs);
        return result;
    }

    public void setObject(ManagedObject object) {
        throw new UnsupportedOperationException("ActionModel is a chained model - don't mess with the chain");
    }

    @Override
    public void clearArguments() {
        this.delegate.resetParametersToDefault();
    }

    @Override
    public InlinePromptContext getInlinePromptContext() {
        return this.delegate.getInlinePromptContext();
    }

    public Stream<UiParameterWkt> streamPendingParamUiModels() {
        return this.delegate.streamParameterUiModels();
    }

    @Override
    public Optional<ScalarParameterModel> getAssociatedParameter() {
        return this.delegate.associatedWithParameter();
    }
}

