/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.model.models.interaction.coll;

import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import org.apache.causeway.core.metamodel.tabular.interactive.DataRow;
import org.apache.causeway.core.metamodel.tabular.interactive.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataRowToggleWkt;
import org.apache.causeway.viewer.wicket.model.models.interaction.coll.DataTableModelWkt;
import org.apache.causeway.viewer.wicket.model.util.PageUtils;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;

public class DataRowWkt
extends ChainingModel<DataRow> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final UUID uuid;
    @NonNull
    private final DataRowToggleWkt dataRowToggle;
    private transient DataRow dataRow;

    public static DataRowWkt chain(IModel<DataTableInteractive> dataTableModelHolder, DataRow dataRow) {
        return new DataRowWkt(dataTableModelHolder, dataRow);
    }

    private DataRowWkt(IModel<DataTableInteractive> dataTableModelHolder, DataRow dataRow) {
        super(dataTableModelHolder);
        this.dataRow = dataRow;
        this.uuid = dataRow.getUuid();
        this.dataRowToggle = new DataRowToggleWkt(this);
    }

    public final DataRow getObject() {
        if (this.dataRow == null) {
            this.dataRow = this.getDataTableModel().lookupDataRow(this.uuid).orElse(null);
            if (this.dataRow == null) {
                PageUtils.pageReload();
            }
        }
        return this.dataRow;
    }

    public Optional<DataRow> dataRow() {
        return Optional.ofNullable(this.getObject());
    }

    public boolean hasMemoizedDataRow() {
        return this.dataRow != null || this.getDataTableModel().lookupDataRow(this.uuid).isPresent();
    }

    private DataTableInteractive getDataTableModel() {
        return (DataTableInteractive)((DataTableModelWkt)super.getTarget()).getObject();
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    public DataRowToggleWkt getDataRowToggle() {
        return this.dataRowToggle;
    }
}

